set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630675';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '2',
      '3',
      '4',
      '1',
      '0',
      '1',
      '0',
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      '0',
      '3',
      '4',
      '4',
      '4',
      '4',
      '0',
      '',
      NULL,
      '',
      '2',
      '2',
      '1',
      '0',
      NULL,
      '',
      '',
      '3',
      '0',
      '1',
      '1',
      '2',
      NULL,
      '3',
      '1',
      '2',
      '1',
      '0',
      '343',
      '11401111',
      68.962074,
      13.407817,
      '4103400',
      2.491981,
      1.135466,
      2,
      1,
      NULL,
      1,
      NULL,
      ' 0-10-1980',
      55,
      65.471606,
      23.050237,
      NULL,
      12,
      5.343765,
      59.067488,
      15,
      6.011935,
      14,
      29,
      12.362868,
      2.549057,
      1.085361,
      NULL,
      NULL,
      20.509229,
      13,
      36,
      3.201789,
      20.476151,
      14.398441,
      NULL,
      8.603420,
      1,
      101.021605,
      116,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      56.312997,
      10.301103,
      8.653140,
      13,
      83.645272,
      96,
      ' 0-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.101476,
      55.309327,
      NULL,
      15,
      33,
      3,
      ' 8-24-1996',
      1,
      0.731270,
      150,
      NULL,
      1.742132,
      167,
      1.752890,
      1.006277,
      2.635655,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1976',
      NULL,
      76.538762,
      15.514164,
      84.705136,
      53,
      51.590731,
      51,
      23.216247,
      35.517789,
      28,
      NULL,
      55,
      ' 3-22-1986',
      11,
      19.703793,
      17,
      47,
      80,
      66.663593,
      NULL,
      NULL,
      7.050415,
      21,
      ' 3-13-1985',
      8.834556,
      7,
      4,
      15,
      25.659693,
      7,
      NULL,
      3,
      NULL,
      65.112748,
      NULL,
      0,
      NULL,
      23.101834,
      1.675545,
      0.574460,
      0.112719,
      1.608901,
      ' 5- 9-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      61.437535,
      NULL,
      '11-19-1982',
      NULL,
      NULL,
      NULL,
      13,
      ' 4- 7-1975',
      23,
      '11-24-2001',
      0.783258,
      21.145904,
      NULL,
      162.855806,
      143.156668,
      ' 8-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      14,
      ' 2-29-1994',
      9,
      3.911220,
      3.785844,
      ' 3- 0-1996',
      1.883416,
      NULL,
      ' 2-27-1988',
      9,
      17,
      18,
      NULL,
      ' 5-10-1979',
      45.008259,
      0,
      33,
      '10-15-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


