set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '0',
      '0',
      '3',
      '2',
      '1',
      '1',
      '0',
      '1',
      '0',
      '1',
      '2',
      '4',
      '1',
      '2',
      '2',
      '0',
      '3',
      '1',
      '4',
      '2',
      '4',
      '3',
      '',
      '0',
      NULL,
      '0',
      '0',
      NULL,
      '1',
      NULL,
      '',
      '',
      '4',
      '4',
      '1',
      NULL,
      '4',
      NULL,
      '1',
      '1',
      '1',
      '4',
      NULL,
      '243',
      '22342014',
      74.317201,
      70.306084,
      '0440140',
      2,
      NULL,
      1,
      0,
      '420011',
      NULL,
      '11-16-1997',
      '10- 1-1979',
      26.126809,
      125,
      45.203104,
      23,
      3,
      7.527312,
      52.887879,
      2,
      21,
      15,
      27,
      NULL,
      24,
      15,
      27,
      4,
      10,
      1,
      42.235080,
      5.888152,
      51.644254,
      15.676032,
      97,
      14.921360,
      1,
      23,
      122,
      90,
      NULL,
      66,
      6,
      ' 9-14-1978',
      48,
      NULL,
      25,
      23.526553,
      156.981058,
      39.866279,
      ' 3- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      11,
      5.449604,
      8.190918,
      2.374270,
      ' 6-28-1979',
      0.352919,
      3,
      NULL,
      NULL,
      NULL,
      154.104519,
      NULL,
      1,
      137.961117,
      NULL,
      NULL,
      NULL,
      '11- 3-1992',
      33.235882,
      60,
      55,
      NULL,
      NULL,
      84,
      38,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      19,
      17.076451,
      18,
      81,
      16.270265,
      108,
      10.504180,
      NULL,
      13.486445,
      NULL,
      NULL,
      NULL,
      3,
      18,
      10.103473,
      1.508619,
      4,
      0,
      11,
      0.441462,
      51,
      1.822909,
      0,
      0,
      15.389590,
      NULL,
      5.057481,
      0,
      1,
      ' 3- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      189,
      NULL,
      ' 3-16-1981',
      NULL,
      NULL,
      NULL,
      22,
      ' 7-12-1992',
      37,
      ' 4-24-1985',
      4.795768,
      8,
      NULL,
      16.658115,
      103.291126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      12,
      NULL,
      37,
      0,
      14.873168,
      ' 0-24-1997',
      2,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


