set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9708246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      '3',
      '3',
      '3',
      NULL,
      NULL,
      '0',
      '1',
      '4',
      '4',
      '4',
      '3',
      '0',
      '1',
      '0',
      '3',
      '',
      '2',
      '',
      NULL,
      '3',
      '0',
      '3',
      '3',
      '',
      '',
      '4',
      '3',
      '1',
      '2',
      '4',
      '3',
      '4',
      '1',
      '2',
      '4',
      '1',
      '041',
      '12131340',
      18,
      23,
      NULL,
      3,
      0.673208,
      0,
      0,
      '210313',
      0.454036,
      NULL,
      '11-16-2000',
      95.332948,
      47.498979,
      6,
      4.260164,
      15,
      20,
      75,
      NULL,
      17.657513,
      14.431228,
      23,
      NULL,
      NULL,
      0.775149,
      4.801601,
      3,
      20.982257,
      6.146100,
      77.676082,
      20.597332,
      48,
      33,
      63.624719,
      7,
      0.514947,
      58,
      143,
      95.800310,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1979',
      5,
      6,
      NULL,
      18,
      NULL,
      184,
      ' 5-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      1.815459,
      1.018015,
      2.497492,
      2.192374,
      3,
      ' 5-29-1999',
      1.103764,
      NULL,
      NULL,
      NULL,
      1,
      128,
      2,
      NULL,
      74,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1974',
      107,
      39.924407,
      66.300971,
      16.409706,
      1,
      75.293354,
      98,
      95,
      82,
      33,
      32,
      6.632095,
      NULL,
      NULL,
      8,
      5,
      NULL,
      12.353624,
      NULL,
      7.044746,
      ' 6-27-1979',
      NULL,
      1,
      '10- 9-1983',
      12,
      15,
      7.841994,
      4,
      19.819589,
      9.730362,
      0,
      9.622203,
      0,
      37.582885,
      0,
      NULL,
      NULL,
      18.789454,
      3,
      NULL,
      0.050358,
      1,
      '11-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      24.527989,
      NULL,
      ' 0- 2-1990',
      NULL,
      NULL,
      NULL,
      4.491547,
      ' 6- 2-1999',
      19.852481,
      ' 8-19-2000',
      0.179102,
      NULL,
      '10- 8-1995',
      139,
      77.321390,
      ' 1-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '10-23-2002',
      5.147961,
      NULL,
      1,
      ' 9-19-2002',
      1.630942,
      86.804793,
      ' 7- 9-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


