set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910497';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3232',
      '12113441',
      NULL,
      '20221321',
      '32423132',
      NULL,
      '03022021',
      '04003200',
      '42441042',
      '21332034',
      '03302412',
      '40243313',
      '21242241',
      '23432014',
      NULL,
      '32004344',
      '44203323',
      '21301030',
      NULL,
      '22000110',
      '12044211',
      '21201430',
      '10022042',
      '40243401',
      '01030410',
      '02203141',
      '00101121',
      '00013143',
      '42220121',
      '14124040',
      '12434410',
      '12434232',
      NULL,
      NULL,
      '01442400',
      '20213414',
      '31241141',
      '03030340',
      '23443431',
      '20213343',
      '34011343',
      NULL,
      '20122031',
      '11402404',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '4022200',
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.265641,
      ' 7-29-1974',
      ' 9-29-1983',
      76,
      NULL,
      32.051177,
      14,
      40,
      10,
      NULL,
      20.468116,
      23,
      15,
      42,
      16,
      NULL,
      NULL,
      30.585390,
      7.762659,
      23,
      12.376591,
      74.938161,
      17,
      55.408418,
      NULL,
      143,
      6.138333,
      NULL,
      7.040285,
      NULL,
      77.414000,
      3,
      244.903543,
      91.564452,
      ' 0-11-1994',
      67,
      30.280941,
      NULL,
      41.302620,
      201,
      NULL,
      ' 9-24-1994',
      1,
      0.449003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0.909245,
      1.178046,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1976',
      129.179132,
      92.972946,
      NULL,
      NULL,
      92.140550,
      123,
      45,
      4.138664,
      115,
      74,
      NULL,
      3,
      NULL,
      18.137639,
      NULL,
      10.458329,
      37.179984,
      83.407689,
      186.495807,
      11.499632,
      NULL,
      28,
      22,
      NULL,
      5,
      12,
      8.593605,
      9,
      14.190153,
      13.177518,
      NULL,
      24.420121,
      NULL,
      92.223836,
      1.749532,
      1.619729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      34,
      24.682300,
      ' 2-24-1982',
      1,
      62,
      ' 3- 9-1987',
      NULL,
      NULL,
      0.781856,
      11.944799,
      ' 9-26-1989',
      41,
      NULL,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      193.383518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348592,
      0.734713,
      NULL,
      4,
      2.461187,
      64.140540,
      1.924011,
      1.063260,
      97.674937,
      3.780977,
      3,
      102,
      NULL,
      4.426455,
      NULL,
      NULL,
      NULL,
      1.671573,
      0.698175,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.304873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      NULL,
      24.227637,
      NULL,
      15,
      4,
      1.630959,
      7,
      1,
      NULL,
      0.417761,
      0,
      NULL,
      NULL,
      ' 7- 7-1978',
      '11-24-2000',
      NULL,
      ' 5- 1-1976',
      ' 7-14-2001',
      NULL,
      NULL);
commit;
end;
/


