set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4130',
      '20010202',
      '34343141',
      '02031314',
      NULL,
      '40433100',
      '13102334',
      '01431333',
      '44103142',
      '44310241',
      '13433414',
      '12234200',
      '23022123',
      '30101012',
      '40432103',
      NULL,
      '04204042',
      '22130310',
      '20042311',
      '40321224',
      '44322214',
      '14201430',
      '14310142',
      NULL,
      NULL,
      NULL,
      '03020223',
      '41110301',
      '32110313',
      '32313243',
      '30204111',
      '40421222',
      NULL,
      '31040034',
      '31342220',
      '40334341',
      '24403001',
      '24034320',
      '22403131',
      NULL,
      '12430024',
      '14302213',
      '24422041',
      NULL,
      '41014043',
      '332',
      '11',
      NULL,
      NULL,
      NULL,
      3.781904,
      1.666499,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-22-1997',
      ' 5-16-1983',
      110,
      NULL,
      21,
      NULL,
      11.280582,
      4.243454,
      20,
      NULL,
      6.090702,
      3,
      8.492071,
      10.915768,
      17,
      NULL,
      18,
      1,
      19,
      9.817270,
      NULL,
      17,
      NULL,
      1,
      29.764538,
      9,
      1,
      NULL,
      45.177756,
      4.047502,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4.103897,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370204,
      13,
      1.454842,
      0.063936,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1990',
      5.415775,
      32,
      2.901439,
      16.339897,
      7.563638,
      5,
      ' 9-26-1990',
      1,
      1.716033,
      136.741839,
      0,
      1.569138,
      NULL,
      NULL,
      5,
      46,
      NULL,
      NULL,
      NULL,
      '11-29-2001',
      10,
      41,
      NULL,
      75.380778,
      75.475725,
      61.082893,
      NULL,
      0,
      NULL,
      NULL,
      77.454353,
      8,
      '10- 0-1979',
      8.989788,
      1,
      12,
      1.829993,
      46,
      NULL,
      2,
      ' 3-11-1988',
      20,
      5.699897,
      ' 3- 2-1978',
      1.079355,
      0.918593,
      1.648059,
      2.584531,
      14,
      5.818589,
      NULL,
      9.901038,
      NULL,
      NULL,
      2.328584,
      6.699220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      7,
      NULL,
      ' 8-14-1980',
      NULL,
      69.878063,
      ' 2-12-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


