set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21421204',
      '42133141',
      '02340344',
      '34004422',
      '04421141',
      '31200333',
      NULL,
      '40443203',
      NULL,
      NULL,
      '22142232',
      '02401123',
      NULL,
      '20031402',
      NULL,
      '40334333',
      '14200013',
      '34223040',
      NULL,
      '20001041',
      NULL,
      '12421011',
      NULL,
      '33314433',
      '01432111',
      '22424244',
      '12334043',
      '42314433',
      '01042143',
      '24200004',
      '22242304',
      NULL,
      '02220323',
      '14244042',
      NULL,
      '31241022',
      '13342432',
      '41124321',
      '42132132',
      '01034422',
      '12334422',
      '21111123',
      '31224111',
      '21410242',
      '230',
      '41',
      NULL,
      NULL,
      '3030323',
      0,
      36.626561,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1986',
      ' 2- 4-1989',
      36,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      51.713143,
      11,
      7,
      7,
      9,
      11.091969,
      21,
      5,
      26,
      5,
      14.768002,
      5,
      55,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      2.513505,
      32,
      53.412784,
      58,
      NULL,
      185.434255,
      80,
      '11-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.668763,
      3,
      NULL,
      0.729393,
      1.284922,
      2,
      1.800505,
      0.915040,
      NULL,
      2.513843,
      0,
      0.150173,
      1.892504,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      5.264046,
      3,
      NULL,
      NULL,
      9,
      NULL,
      0.731055,
      2,
      63.191246,
      1.501635,
      NULL,
      89.915028,
      0.698054,
      1,
      34,
      0,
      1.915213,
      85.328427,
      ' 7- 3-1981',
      48,
      22.195035,
      109,
      77.190120,
      107,
      26,
      13.716825,
      22.369869,
      89.312510,
      78,
      70.119992,
      0,
      ' 8- 5-1979',
      4.901916,
      29.275330,
      7.791124,
      NULL,
      13,
      71,
      4,
      ' 5-13-1974',
      NULL,
      14,
      '11- 3-1981',
      0.245993,
      0,
      5,
      27.374178,
      13.236516,
      5.447533,
      1,
      16.779909,
      0,
      NULL,
      1.619952,
      NULL,
      14.480500,
      11,
      2,
      1,
      1,
      1,
      ' 5-12-1983',
      4.711879,
      1,
      1,
      ' 4-18-1986',
      45.946111,
      9,
      ' 6-17-1977',
      NULL,
      NULL,
      NULL,
      52.608087,
      ' 2- 0-1992',
      13.825598,
      ' 4-10-1990',
      NULL,
      7,
      ' 8- 2-1979',
      72.905202,
      54,
      ' 6- 3-1996',
      NULL,
      3.599188,
      ' 5-28-1994',
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      ' 0- 8-1996',
      21,
      13,
      4.238280,
      ' 0-13-1980',
      0,
      297.637657,
      ' 6-20-1999',
      13,
      23.749896,
      5.046334,
      37.706038,
      ' 4- 9-1985',
      57.373324,
      0.417351,
      269.374562,
      ' 9- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.496897);
commit;
end;
/


