set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1434',
      '01213444',
      '11411344',
      '03233102',
      '21011122',
      '04401330',
      '41340113',
      '00011112',
      '31342430',
      '03043331',
      NULL,
      '20034004',
      NULL,
      '01204202',
      '04132112',
      '14314013',
      '01443214',
      '13002144',
      '22110100',
      '40244320',
      NULL,
      '44302132',
      '33204241',
      '00204120',
      '30332312',
      '31311412',
      NULL,
      NULL,
      NULL,
      '20404112',
      '32421342',
      NULL,
      '30330103',
      '20023223',
      '33242012',
      '20223244',
      '20410413',
      '34413114',
      '02030333',
      '12030131',
      '41022403',
      '20422000',
      '32044324',
      '24014114',
      '10322002',
      '003',
      '24',
      21,
      15.302529,
      '0112033',
      2,
      12,
      0,
      NULL,
      '302422',
      0.481761,
      ' 3-24-2002',
      ' 3-27-1978',
      79,
      43,
      25,
      15.923269,
      12,
      3,
      78.269177,
      11,
      6.938503,
      NULL,
      27,
      0,
      2,
      NULL,
      24,
      6.001762,
      3,
      4,
      13.765294,
      13,
      2.507468,
      7,
      58,
      3.258262,
      NULL,
      7,
      118,
      42.554983,
      NULL,
      155.471153,
      14,
      ' 9- 4-1980',
      29,
      9.396148,
      25.289255,
      8,
      115.563811,
      90.135875,
      ' 6-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.963291,
      3.980756,
      NULL,
      6.884718,
      14,
      1.395399,
      NULL,
      1,
      NULL,
      155,
      0,
      4.655728,
      26.847593,
      0.588489,
      NULL,
      35.000932,
      NULL,
      NULL,
      NULL,
      ' 2-22-1989',
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      68,
      20.289116,
      NULL,
      77.701282,
      NULL,
      44,
      '11- 7-2000',
      1,
      NULL,
      13.421336,
      33,
      NULL,
      28,
      9.005207,
      ' 0- 8-1976',
      5.902488,
      0,
      ' 9-19-1999',
      3.376517,
      15.005676,
      7.548660,
      8,
      NULL,
      1.995574,
      1,
      12.677794,
      1.933504,
      69.235102,
      NULL,
      NULL,
      15,
      23.514090,
      1,
      1,
      5,
      1.754263,
      ' 8-15-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      103.336055,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 6- 2-2003',
      30.302580,
      '10-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      19.427665,
      ' 1-14-1991',
      65,
      14.519158,
      NULL,
      ' 6-10-1978',
      NULL,
      111.750114,
      ' 6- 2-1991',
      10.717150,
      27,
      13,
      12.541044,
      ' 8-20-1988',
      9.549575,
      0,
      272,
      ' 5- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


