set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      '0',
      '3',
      '0',
      '4',
      '4',
      '4',
      NULL,
      '3',
      '2',
      '4',
      '2',
      NULL,
      '1',
      '4',
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      '',
      '2',
      '1',
      NULL,
      '3',
      '4',
      '',
      '',
      NULL,
      '0',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '1',
      '3',
      '3',
      '2',
      '023',
      '22104112',
      70,
      NULL,
      '3210002',
      NULL,
      162,
      2,
      NULL,
      '001122',
      0,
      ' 1-22-1982',
      ' 1-18-1979',
      125.036521,
      NULL,
      4,
      18.586973,
      3,
      6.354191,
      55,
      15.619670,
      15.136080,
      NULL,
      14.534790,
      0,
      NULL,
      11,
      NULL,
      NULL,
      4,
      17,
      0.995870,
      5.775642,
      14.079314,
      2.115110,
      6.980700,
      4.616951,
      0.675031,
      2.409203,
      130,
      53,
      130,
      2,
      78,
      '10-24-1975',
      19,
      NULL,
      26,
      NULL,
      82.972687,
      102.557356,
      ' 6- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.045296,
      9.003207,
      14.784566,
      1,
      NULL,
      0.867818,
      ' 6- 8-1974',
      1.452276,
      NULL,
      159,
      NULL,
      0.032684,
      54.176477,
      0.082432,
      3.896946,
      41,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1997',
      125,
      127.960842,
      111.363079,
      NULL,
      NULL,
      38,
      4.141222,
      31,
      NULL,
      55,
      31,
      90.893248,
      ' 2-26-1992',
      8.633098,
      5.093088,
      12.515446,
      50,
      25,
      47.361295,
      NULL,
      ' 8- 8-1990',
      18,
      20.078991,
      NULL,
      0.351921,
      6,
      2.033595,
      5.849937,
      1.208916,
      2,
      0,
      6,
      0.608602,
      10,
      1,
      1,
      4.976210,
      8,
      9.646426,
      8,
      NULL,
      0.298959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.773642,
      1.810935,
      ' 5- 1-1988',
      NULL,
      NULL,
      NULL,
      23,
      '11- 1-2003',
      16,
      '10-16-1993',
      7.812542,
      3.230446,
      ' 9- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19,
      '10- 4-1994',
      NULL,
      14,
      10,
      '11-16-1996',
      0.091405,
      19.508196,
      ' 4-16-1980',
      NULL,
      146.261837,
      NULL,
      10.172550,
      ' 5-12-2000',
      30,
      1,
      101.799359,
      '11-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


