set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405317';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '24213334',
      NULL,
      '44400304',
      NULL,
      '13424422',
      '31312221',
      '31400141',
      NULL,
      NULL,
      NULL,
      '40331300',
      '03121404',
      '22412220',
      '42343221',
      '40103311',
      '33012323',
      '24034124',
      '12431444',
      '10012332',
      '22231214',
      '14004314',
      '32243141',
      '03341412',
      '21011030',
      '31003402',
      '11211303',
      '01033002',
      '20023311',
      '10331130',
      '24402230',
      '11310334',
      '03304210',
      '24121144',
      '11421340',
      '20203211',
      NULL,
      '01030412',
      '30302004',
      NULL,
      '04212321',
      '14242111',
      '24422330',
      NULL,
      '24204044',
      '223',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975458,
      1,
      NULL,
      NULL,
      NULL,
      ' 3-21-1995',
      ' 9-11-1995',
      5.699986,
      NULL,
      6.906072,
      NULL,
      20.087795,
      9,
      10,
      14,
      25,
      NULL,
      50,
      7,
      21.953131,
      NULL,
      6.594728,
      NULL,
      6.041217,
      0.153411,
      41.110069,
      0.939930,
      NULL,
      24,
      87.030982,
      5.528190,
      0,
      61,
      164.271059,
      92,
      77,
      145,
      NULL,
      ' 1- 6-1983',
      28,
      NULL,
      9.936353,
      4,
      139,
      39,
      ' 2-22-1987',
      1,
      0.009985,
      1.456804,
      NULL,
      1,
      1,
      1.507703,
      1,
      1.652070,
      1,
      2,
      1,
      NULL,
      0,
      1,
      0,
      0.275066,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1989',
      50.345571,
      11,
      19,
      23,
      NULL,
      2.597262,
      ' 4-17-1977',
      0.474515,
      1,
      22.998764,
      0.182743,
      NULL,
      148.494492,
      1,
      5,
      13,
      NULL,
      NULL,
      NULL,
      '11-18-1979',
      80,
      63.206162,
      74,
      100.947728,
      45.747663,
      54,
      NULL,
      0,
      NULL,
      78,
      18,
      32,
      '11-23-1993',
      8,
      0,
      19.263060,
      81.331194,
      52.636711,
      NULL,
      NULL,
      ' 2-10-2001',
      4,
      21,
      ' 2- 3-1992',
      18.579275,
      20.698621,
      20.443715,
      3.068179,
      18,
      5.663237,
      NULL,
      23,
      0,
      75.589311,
      NULL,
      0,
      25.680884,
      27,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      264,
      NULL,
      ' 1-19-1986',
      NULL,
      NULL,
      NULL,
      31.390023,
      ' 0- 0-1992',
      NULL,
      ' 6-26-1979',
      8,
      0,
      ' 6-22-1995',
      52.849168,
      82.104946,
      ' 1- 5-1976',
      5,
      8,
      '11- 3-1983',
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      ' 8-25-2001',
      32.694339,
      NULL,
      33,
      NULL,
      NULL,
      4.478962,
      ' 4-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


