set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '0',
      '1',
      '4',
      '1',
      '0',
      '2',
      '1',
      '0',
      NULL,
      '4',
      '3',
      '0',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '2',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '3',
      '0',
      '0',
      '1',
      '3',
      '',
      '',
      '4',
      '0',
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '3',
      '2',
      '1',
      '4',
      '303',
      '43434102',
      NULL,
      61.436622,
      '0120300',
      3,
      27.010048,
      2,
      NULL,
      NULL,
      1,
      NULL,
      ' 7- 7-1980',
      14,
      NULL,
      8.094801,
      15,
      10.141076,
      11,
      24,
      5,
      8,
      NULL,
      3.729224,
      6,
      13,
      5,
      11.821273,
      5.398201,
      NULL,
      1,
      64,
      9,
      NULL,
      5.149617,
      69.088118,
      15,
      3.270300,
      68.217478,
      120.545322,
      47,
      109.420636,
      78,
      69.538037,
      ' 6-12-1982',
      4,
      15.357537,
      17.741820,
      7,
      27,
      NULL,
      ' 1-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88.010612,
      7.693470,
      6.070857,
      8,
      NULL,
      NULL,
      ' 6- 4-1996',
      1,
      0.199835,
      19.827020,
      1,
      NULL,
      44,
      0.853716,
      0.057127,
      34.113795,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1977',
      44,
      NULL,
      93.025289,
      57,
      33,
      NULL,
      22,
      89.065659,
      15,
      53,
      102,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      62.251928,
      42.247365,
      NULL,
      NULL,
      ' 6-22-1978',
      NULL,
      NULL,
      NULL,
      5.475693,
      NULL,
      NULL,
      13.903678,
      0.345635,
      NULL,
      1.491923,
      NULL,
      1.367145,
      72.578800,
      2.071246,
      0.935259,
      1,
      24,
      3.615418,
      3,
      0.547635,
      0.807359,
      '10- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      129.401967,
      106.169233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      5,
      5.901202,
      NULL,
      14.126046,
      98,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      27.533742,
      ' 2-25-1997',
      11,
      40,
      33,
      ' 5- 8-1981',
      2.636443,
      73,
      ' 3-13-1997',
      15.189028,
      70,
      14,
      65.737452,
      ' 0- 7-1989',
      24.195152,
      2,
      60.013577,
      '11- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


