set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0320',
      NULL,
      '02014122',
      '24440310',
      '03401334',
      '22212343',
      '30203122',
      '22110231',
      NULL,
      '21221433',
      '20242442',
      '13043013',
      '43311232',
      '24304424',
      NULL,
      '11401410',
      '42332103',
      '04124143',
      NULL,
      NULL,
      '02240121',
      NULL,
      '42332442',
      '24421422',
      '11231331',
      '40333142',
      '14230440',
      '10204401',
      '44330421',
      '14303202',
      NULL,
      '44332101',
      NULL,
      '31120311',
      '21003203',
      '44333313',
      '14332434',
      '10100232',
      '43414012',
      '20240004',
      '04102113',
      NULL,
      '44304301',
      '04402311',
      '01424233',
      '414',
      '13',
      NULL,
      NULL,
      '1321111',
      0.369140,
      0,
      3,
      NULL,
      '420131',
      5.743683,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      11,
      18.390418,
      10.659443,
      44.476998,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      13.220596,
      NULL,
      12.315424,
      12.121281,
      NULL,
      8,
      13.899923,
      8.162337,
      40,
      11.386982,
      1.593397,
      98,
      160.871870,
      93.254220,
      NULL,
      179,
      NULL,
      ' 3-25-1989',
      25.297935,
      6.069057,
      21.265178,
      NULL,
      19,
      153,
      '10- 6-1999',
      NULL,
      1,
      1,
      6.366632,
      5,
      2.605125,
      4,
      NULL,
      NULL,
      0,
      5.260771,
      NULL,
      1,
      NULL,
      NULL,
      0.875121,
      2,
      1.790988,
      1.802998,
      23.089924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.813747,
      NULL,
      21.663717,
      NULL,
      18.214123,
      7.410168,
      ' 5- 5-1975',
      2.995664,
      5,
      NULL,
      4.156460,
      0.214700,
      2.949323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.483015,
      105.942186,
      99.692132,
      NULL,
      70.276097,
      48,
      NULL,
      NULL,
      40,
      NULL,
      40,
      '10-15-1991',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      ' 3-14-1984',
      1,
      6,
      ' 2- 3-1990',
      NULL,
      6,
      2.365421,
      NULL,
      10.611124,
      NULL,
      0,
      NULL,
      NULL,
      111.552061,
      1,
      5,
      NULL,
      4,
      0.336738,
      NULL,
      5,
      0.984288,
      ' 3- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      9.831875,
      ' 5-11-2001',
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      43,
      ' 9-21-1982',
      4,
      9.401585,
      NULL,
      22.585047,
      23.536963,
      ' 1-19-1979',
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      ' 6-14-1975',
      57.195225,
      NULL,
      10.823069,
      '11-21-1985',
      2.695392,
      113.497358,
      NULL,
      3.794137,
      36,
      0.096172,
      50,
      ' 5-12-1999',
      51.032122,
      1.247643,
      65.840414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


