set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8818590';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '2',
      '0',
      '4',
      '4',
      '1',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '1',
      '0',
      NULL,
      '4',
      '4',
      '0',
      '4',
      '1',
      NULL,
      '',
      '3',
      NULL,
      '0',
      '1',
      '0',
      '2',
      '4',
      '',
      NULL,
      '1',
      '2',
      '1',
      '1',
      '1',
      '4',
      '2',
      '4',
      '0',
      '1',
      NULL,
      '334',
      '21431310',
      14,
      NULL,
      '1123223',
      1.501478,
      41,
      3,
      0,
      NULL,
      3,
      ' 9-17-1979',
      ' 8-12-1991',
      107.690125,
      28,
      20.995445,
      11.670581,
      5,
      6,
      26.241347,
      2,
      6,
      NULL,
      11.868853,
      1.655070,
      34,
      4.949425,
      16,
      10.929344,
      22,
      NULL,
      17,
      5,
      42,
      5.252346,
      4,
      9,
      1,
      19.170228,
      102,
      NULL,
      184.670515,
      107.892182,
      NULL,
      NULL,
      31,
      19,
      5,
      0,
      175,
      149.718933,
      ' 1- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.214220,
      1.600013,
      1,
      0.669218,
      NULL,
      8.752967,
      ' 1-22-1991',
      1.269067,
      1.497794,
      132,
      1.314165,
      1,
      79,
      1,
      1.444106,
      7.611104,
      NULL,
      NULL,
      NULL,
      ' 4-20-1999',
      37.322829,
      44,
      NULL,
      NULL,
      NULL,
      45,
      23,
      66.576032,
      47.575718,
      34.408001,
      27.137625,
      53.290771,
      ' 2-20-1988',
      2.987819,
      4,
      NULL,
      1,
      27,
      0.352275,
      0.131849,
      '10-16-1991',
      NULL,
      2,
      ' 9- 2-2002',
      6.177309,
      2,
      8,
      15,
      10,
      9.131659,
      NULL,
      8,
      NULL,
      96,
      1.501355,
      NULL,
      11.586480,
      4.233682,
      1,
      1,
      NULL,
      0,
      ' 3-10-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      ' 0-22-1988',
      19,
      ' 2-23-1984',
      NULL,
      10.963724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      17,
      ' 2- 3-1985',
      33,
      16,
      2.169664,
      ' 1- 4-1995',
      0.893017,
      101,
      NULL,
      NULL,
      NULL,
      14.486661,
      14.126095,
      '10-12-1996',
      43.547017,
      1.597591,
      NULL,
      ' 1- 6-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


