set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1324',
      '41322344',
      '20323124',
      '12240032',
      '43333102',
      NULL,
      '30134400',
      '03204430',
      '31240130',
      '02440411',
      '23202124',
      '34210302',
      '40223111',
      '13124143',
      '01434430',
      '22002004',
      '44410000',
      '42012103',
      '21331042',
      '14402222',
      '12403000',
      '41012442',
      '44230311',
      NULL,
      '24402022',
      '30241324',
      '14313210',
      '42222143',
      '14130411',
      '21441303',
      '21220010',
      '44114200',
      '02023401',
      NULL,
      '33314240',
      NULL,
      '04324431',
      '34134030',
      '42424311',
      NULL,
      '41210313',
      '20442300',
      '14221431',
      NULL,
      '22441431',
      '',
      NULL,
      NULL,
      NULL,
      '3313033',
      3,
      1.237892,
      2,
      NULL,
      '222200',
      0,
      ' 3-12-1980',
      '11- 1-1983',
      11.842798,
      NULL,
      36.486989,
      8.924526,
      NULL,
      18.156321,
      73,
      1,
      4.382845,
      20,
      20.487800,
      10.020855,
      33.133540,
      13,
      18,
      NULL,
      NULL,
      15.644760,
      NULL,
      17.859612,
      NULL,
      6.388103,
      34,
      7.077667,
      NULL,
      47.064111,
      108,
      15,
      83.673040,
      37,
      65.144879,
      ' 2-28-1984',
      50,
      49,
      22,
      7,
      174.806496,
      46.678982,
      ' 0-25-1998',
      1.980806,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882702,
      0.695173,
      NULL,
      NULL,
      0.425636,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1978',
      19,
      NULL,
      80.814153,
      56,
      76.227723,
      38,
      44,
      12,
      42.068401,
      NULL,
      65,
      NULL,
      ' 6-21-1983',
      14.285438,
      NULL,
      16,
      36,
      37.494394,
      44.424268,
      6.917810,
      ' 4-15-1991',
      17,
      23.087832,
      '10-22-1979',
      1.178534,
      2,
      10.188442,
      0,
      NULL,
      6.535970,
      NULL,
      2.603887,
      NULL,
      NULL,
      1.164057,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      26,
      28.801822,
      NULL,
      1.279735,
      NULL,
      ' 4- 4-1999',
      14,
      12.161090,
      9.454797,
      63.978577,
      ' 0- 5-1990',
      29.171910,
      1.373780,
      451,
      ' 4-18-1976',
      NULL,
      NULL,
      NULL,
      30,
      115.042144,
      48,
      NULL,
      NULL,
      NULL,
      111,
      11,
      10.540250,
      35,
      6,
      21.647712,
      1,
      0.149528,
      49.043629,
      NULL,
      NULL,
      NULL,
      0.133770,
      0.686249,
      90.882661,
      2.177824,
      0.242441,
      222,
      3,
      22.812073,
      22,
      0,
      NULL,
      0,
      0,
      1.739622,
      1.975459,
      1.820343,
      1.359708,
      21,
      45.216392,
      47.400163,
      18,
      NULL,
      NULL,
      1,
      0,
      19.332310,
      1,
      2.743028,
      21,
      17.628837,
      3.894742,
      45.277035,
      NULL,
      68.446409,
      1,
      NULL,
      NULL,
      8,
      NULL,
      13.481572,
      63,
      44,
      NULL,
      27.089485,
      11.861666,
      8.750500,
      0,
      2.279937,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      ' 4- 4-1990',
      ' 7-29-1993',
      NULL,
      ' 8-12-1978',
      '11- 8-1978',
      ' 6-16-1988',
      NULL,
      NULL);
commit;
end;
/


