set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0221',
      NULL,
      NULL,
      '33301233',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41432444',
      '23320243',
      '10224421',
      '13411211',
      '44213402',
      '20031132',
      NULL,
      '24210310',
      '44001113',
      '41222212',
      '10230331',
      '23313230',
      NULL,
      '04334031',
      '22333404',
      '20123021',
      '11141123',
      '20314420',
      '24332112',
      '42030212',
      '04234441',
      NULL,
      NULL,
      '12430024',
      '43203022',
      '11423104',
      '40232432',
      '21434004',
      '24043222',
      '23134421',
      '14002122',
      '02203132',
      '42231340',
      '43100002',
      '34003201',
      NULL,
      '320',
      NULL,
      NULL,
      NULL,
      '2002214',
      1.226946,
      28.544933,
      NULL,
      NULL,
      '431120',
      5,
      ' 7-12-1981',
      '11- 2-1976',
      50,
      NULL,
      7.185198,
      19.381301,
      NULL,
      1,
      1.014761,
      1.326380,
      28,
      27,
      32.965849,
      9.255151,
      9,
      11,
      29.870430,
      2,
      2.291581,
      6.453469,
      29.448279,
      15,
      39.311459,
      15.847576,
      16.987300,
      2,
      0,
      99.270924,
      190,
      105.782022,
      197,
      35,
      NULL,
      ' 6-20-2002',
      3,
      6.812865,
      NULL,
      29.930673,
      95,
      141,
      ' 1-21-1975',
      2.549457,
      6,
      3.290040,
      0.877840,
      1.424139,
      1.692625,
      5.380718,
      1.307641,
      NULL,
      1.897384,
      6,
      1.639789,
      0,
      1,
      1,
      1.878275,
      2.808288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-22-1993',
      11,
      NULL,
      NULL,
      8,
      NULL,
      2.045446,
      ' 0-21-1982',
      1,
      0,
      NULL,
      1.947303,
      4.846951,
      85.129096,
      1,
      1.957502,
      12,
      1,
      NULL,
      NULL,
      ' 9-24-1989',
      60.318639,
      54,
      28,
      69,
      30,
      97,
      10,
      30.743416,
      4.878470,
      39,
      59,
      2.646425,
      NULL,
      14,
      4.848021,
      4,
      27,
      31,
      NULL,
      2,
      ' 4- 1-1987',
      4,
      19,
      ' 5-12-1991',
      10,
      5,
      NULL,
      10.909400,
      10.747490,
      1.767782,
      3.426093,
      9,
      2,
      NULL,
      0,
      3,
      0.841959,
      15,
      0,
      NULL,
      20,
      NULL,
      ' 2-23-2000',
      2,
      2.543803,
      NULL,
      ' 8-11-1976',
      8.252636,
      13,
      ' 0- 8-1983',
      NULL,
      NULL,
      NULL,
      34,
      ' 5-13-1986',
      11.748821,
      ' 9- 6-1993',
      12,
      2,
      ' 0- 2-1995',
      15,
      103,
      ' 4-19-1980',
      NULL,
      11,
      ' 6- 7-1999',
      NULL,
      3,
      ' 5-18-1996',
      0,
      1,
      8.478655,
      NULL,
      54.360739,
      23.862649,
      29.941062,
      NULL,
      0.190243,
      24,
      ' 6-18-1985',
      2,
      11,
      5.853516,
      NULL,
      ' 0-14-1986',
      13.867981,
      0.500556,
      31.147832,
      ' 9-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.824882);
commit;
end;
/


