set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '3',
      '1',
      NULL,
      '0',
      '4',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '4',
      '2',
      '0',
      '2',
      NULL,
      '0',
      '1',
      '1',
      '0',
      NULL,
      '3',
      '0',
      NULL,
      '0',
      '',
      '4',
      '4',
      NULL,
      '4',
      '3',
      '',
      '',
      '3',
      '1',
      '4',
      '2',
      '2',
      '3',
      '4',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '30313014',
      NULL,
      NULL,
      '3034431',
      2,
      125.941023,
      NULL,
      0,
      '113022',
      4,
      ' 8-17-1980',
      ' 6-14-1974',
      20.153848,
      NULL,
      0,
      NULL,
      10,
      NULL,
      15,
      12.612333,
      27.953209,
      NULL,
      NULL,
      10,
      9,
      NULL,
      24.952751,
      7.196363,
      32,
      1.888853,
      15.098081,
      NULL,
      30.073982,
      15.845412,
      NULL,
      NULL,
      NULL,
      20.452584,
      33,
      78.458863,
      NULL,
      167.483596,
      24,
      ' 0- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.762792,
      5,
      6,
      10,
      6.917073,
      NULL,
      NULL,
      1.343365,
      1.467142,
      NULL,
      1.654214,
      1,
      125.791710,
      0.300976,
      0.763696,
      45,
      NULL,
      NULL,
      NULL,
      ' 9-22-1986',
      44,
      85.001772,
      101.486910,
      NULL,
      99,
      91.964588,
      66.964746,
      28,
      46.189873,
      21,
      NULL,
      77.136876,
      ' 3-25-1993',
      6,
      15.850418,
      NULL,
      45.712720,
      NULL,
      4.326246,
      0.623538,
      NULL,
      11.976050,
      24.984721,
      ' 4-11-1991',
      6,
      0.531106,
      4,
      6.375779,
      14,
      6.409380,
      NULL,
      7.757809,
      0,
      49.351731,
      NULL,
      1,
      0,
      17,
      0,
      19,
      1,
      0,
      ' 7-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      87.094859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      ' 7- 3-1990',
      6,
      0,
      NULL,
      NULL,
      146,
      ' 9-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      10.790775,
      ' 6- 4-1985',
      40,
      NULL,
      4.891804,
      '10- 8-1985',
      NULL,
      107,
      NULL,
      11,
      NULL,
      11.686592,
      65.430113,
      ' 3- 6-2000',
      62,
      0.369392,
      153,
      ' 8-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


