set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3114',
      '04133430',
      '02420230',
      '43410243',
      '11012330',
      NULL,
      '44241400',
      NULL,
      '10032111',
      NULL,
      NULL,
      NULL,
      '24042021',
      '00112010',
      '22422010',
      '22304122',
      '33134424',
      '02111434',
      '03031142',
      '13400033',
      '23402320',
      '41441103',
      '41400042',
      '00122204',
      '43020130',
      NULL,
      NULL,
      '00424140',
      '11210444',
      '24333210',
      NULL,
      '10040133',
      '01221422',
      '44302433',
      '31401141',
      '30402423',
      '04431044',
      '34234231',
      NULL,
      '11414103',
      '21043123',
      '33001442',
      '44014220',
      '04304013',
      '24134342',
      '413',
      '13',
      NULL,
      NULL,
      '4433211',
      2,
      0.561600,
      NULL,
      NULL,
      '043304',
      NULL,
      ' 1-23-1998',
      '11- 0-1985',
      66,
      NULL,
      29.594036,
      14,
      2.723304,
      NULL,
      2.260408,
      NULL,
      14.509715,
      15.630188,
      NULL,
      NULL,
      7.588369,
      5.891409,
      17,
      8,
      20,
      7.627513,
      14,
      1.727033,
      37.904063,
      NULL,
      NULL,
      12,
      0.132010,
      27,
      97,
      28,
      85.640750,
      142,
      143.245022,
      NULL,
      29,
      4.615297,
      8.698927,
      11,
      113.999873,
      191.994761,
      ' 1-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      NULL,
      13,
      15.635099,
      3.421529,
      NULL,
      0,
      0.663830,
      122,
      NULL,
      1.328632,
      NULL,
      1,
      6,
      43.447425,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1998',
      32,
      20,
      NULL,
      7,
      4.798182,
      18,
      12,
      49,
      NULL,
      25,
      55,
      29.588060,
      ' 0- 8-1983',
      17.689683,
      2.793520,
      7,
      22,
      16,
      4,
      4,
      ' 0-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.254464,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      ' 0-28-1977',
      8,
      '11- 0-1992',
      NULL,
      15.333438,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439713,
      NULL,
      ' 2- 6-1992',
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      ' 9-23-1982',
      24,
      52.119556,
      18.810160,
      NULL,
      NULL,
      47,
      '10- 6-1988',
      NULL,
      37,
      NULL,
      75,
      ' 2-10-1999',
      42.664983,
      0,
      39.511903,
      ' 3-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


