set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8104779';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '3',
      '3',
      '1',
      '3',
      '4',
      '4',
      '2',
      NULL,
      '2',
      NULL,
      '3',
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '4',
      '4',
      '2',
      '3',
      NULL,
      NULL,
      '',
      '4',
      NULL,
      '2',
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '2',
      '4',
      '0',
      '043',
      '40143421',
      56,
      52,
      '4032421',
      1.545481,
      0.456255,
      NULL,
      NULL,
      '431341',
      1,
      NULL,
      ' 5-23-1994',
      192.725946,
      35.620230,
      32,
      18.710549,
      24.805029,
      13,
      42,
      15,
      12,
      8.130240,
      33.234334,
      NULL,
      41,
      16.179992,
      6.839460,
      19,
      20,
      7.190812,
      NULL,
      16.358979,
      30,
      7.509510,
      87.459661,
      NULL,
      NULL,
      74.764717,
      NULL,
      94.966396,
      61,
      22.656215,
      49.662763,
      ' 3-13-1994',
      60,
      NULL,
      37,
      NULL,
      143.061460,
      189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      6.124126,
      0.865735,
      6.725514,
      8,
      ' 3-24-1996',
      1,
      0,
      118,
      NULL,
      1,
      NULL,
      0,
      1,
      108.374558,
      NULL,
      NULL,
      NULL,
      NULL,
      58.427598,
      NULL,
      NULL,
      78.609862,
      NULL,
      14.768746,
      85,
      29,
      NULL,
      19.388995,
      70.690653,
      48.168220,
      ' 6-19-1992',
      16.729376,
      13,
      21.965022,
      19.020057,
      31.830235,
      52,
      10,
      ' 9- 8-2003',
      7.169224,
      10.271537,
      ' 8- 4-1996',
      9.582093,
      15.415358,
      6.432947,
      8,
      NULL,
      3,
      0.177140,
      12,
      NULL,
      77,
      0,
      7,
      7,
      23,
      1.814482,
      NULL,
      1,
      0.160702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      0,
      '10- 6-1985',
      NULL,
      NULL,
      NULL,
      34,
      ' 4-27-1987',
      14,
      ' 9-10-1986',
      10.815524,
      7,
      ' 4-21-1986',
      133,
      107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.546775,
      NULL,
      60.327731,
      NULL,
      6.065673,
      ' 4-12-2002',
      2.098091,
      NULL,
      ' 6-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


