set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8634519';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1324',
      '43011203',
      NULL,
      '20013221',
      '01100222',
      '24441123',
      '21114131',
      '24410213',
      '34210142',
      '14301433',
      '32404332',
      '23123433',
      '12144134',
      '24242400',
      '21121142',
      '44134001',
      '13042022',
      '23233304',
      '02244223',
      '02434032',
      '11014232',
      '04203433',
      '42320303',
      '43314422',
      '12134200',
      '33123022',
      '23011220',
      '44210040',
      '31310300',
      '11420134',
      '34410234',
      '22112022',
      '04413112',
      '10220332',
      '33402213',
      NULL,
      '14243320',
      '14133033',
      '20041244',
      '23230342',
      '44042412',
      '43232043',
      '24440343',
      '44121110',
      NULL,
      '331',
      NULL,
      NULL,
      NULL,
      '2402123',
      3.731010,
      1.389577,
      2,
      NULL,
      '422140',
      0.774373,
      '11- 3-1999',
      ' 9-17-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      51,
      ' 9-14-1999',
      NULL,
      NULL,
      34,
      9.036941,
      NULL,
      102.062910,
      ' 6-14-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      199,
      1,
      NULL,
      NULL,
      2.742980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1985',
      37,
      NULL,
      66,
      NULL,
      50.039054,
      73.850497,
      21.497452,
      22.918561,
      NULL,
      63.654940,
      70.593563,
      61,
      ' 3- 7-1989',
      30,
      11,
      6.484254,
      31.698964,
      12.305788,
      108.055229,
      3,
      '10- 0-1980',
      20.761431,
      NULL,
      ' 6-11-1981',
      17.386102,
      11.690578,
      NULL,
      16,
      10.219912,
      10.847864,
      1,
      21.788195,
      0,
      133.672845,
      1.049618,
      2,
      3.919686,
      19,
      1,
      1.349325,
      1.651903,
      1,
      ' 6- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      41,
      ' 9- 4-1974',
      NULL,
      NULL,
      NULL,
      13.597842,
      NULL,
      NULL,
      NULL,
      10.420421,
      NULL,
      ' 1- 5-1979',
      108,
      26.212619,
      ' 7-13-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 7-24-1978',
      2.360161,
      2.286368,
      NULL,
      ' 4-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


