set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3001',
      '31403203',
      '13423401',
      NULL,
      '23111401',
      NULL,
      '13400110',
      '43423403',
      '21414344',
      '11312201',
      '13003020',
      '22023243',
      '22344011',
      '44112032',
      '21441434',
      '43400444',
      '42221230',
      NULL,
      '00202433',
      '44202300',
      '04122322',
      '22123404',
      NULL,
      '12000043',
      NULL,
      NULL,
      '22034443',
      '40230401',
      NULL,
      '20023102',
      '40311301',
      '40221431',
      '42342434',
      NULL,
      NULL,
      '33220404',
      '23222110',
      '13441034',
      '42221433',
      '24042321',
      '01004140',
      '32322021',
      '23131412',
      '32242423',
      '10401204',
      NULL,
      '34',
      NULL,
      NULL,
      '2100002',
      2.541820,
      0,
      1,
      NULL,
      '223304',
      1.584680,
      '10- 1-1999',
      ' 0-23-1978',
      81.560906,
      NULL,
      4,
      7,
      9,
      9,
      12,
      6,
      7,
      8.899739,
      37.838705,
      0,
      35.963486,
      4,
      NULL,
      1.752339,
      8.114657,
      4,
      31.354376,
      6,
      12,
      0.497782,
      NULL,
      6,
      1,
      95,
      NULL,
      15.592997,
      113.210101,
      8.278418,
      163.447087,
      ' 1-22-1974',
      NULL,
      NULL,
      15,
      19.802482,
      NULL,
      30.023559,
      ' 7-26-1991',
      NULL,
      20.095916,
      6.198336,
      NULL,
      4.580654,
      9,
      NULL,
      2.317240,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.625140,
      1,
      1,
      13.410397,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1985',
      45,
      14.885412,
      10.558301,
      4.280948,
      17,
      1,
      ' 5-19-1991',
      1.683014,
      1,
      115.644766,
      7.974134,
      1.564063,
      NULL,
      5.625956,
      3.823492,
      30,
      NULL,
      NULL,
      NULL,
      ' 6-21-2002',
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      14.945535,
      NULL,
      31.273471,
      7.053427,
      44.214862,
      27,
      11,
      ' 3-16-2003',
      31,
      9.707352,
      20.835129,
      1,
      70,
      NULL,
      8.899587,
      ' 0-27-2002',
      8,
      7,
      NULL,
      NULL,
      NULL,
      13.104887,
      6.040182,
      10,
      3,
      3.991223,
      5.205003,
      0,
      59.771569,
      NULL,
      2.093170,
      6,
      6,
      8,
      3,
      5,
      0,
      ' 7- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      13.966867,
      7.119108,
      ' 9- 6-1997',
      NULL,
      NULL,
      NULL,
      15,
      ' 1-17-1981',
      26,
      ' 6-10-1977',
      10.668420,
      10,
      NULL,
      52.726415,
      NULL,
      ' 4-27-1997',
      NULL,
      1.694471,
      '10-12-1975',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 4-20-1987',
      41.406231,
      8,
      NULL,
      '10-16-2000',
      NULL,
      532,
      ' 2-18-1974',
      0,
      32,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      194.367640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


