set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2012',
      '21000121',
      NULL,
      '00431411',
      NULL,
      NULL,
      '04300133',
      '21341100',
      '31044243',
      '14442033',
      '44030422',
      '30021034',
      '00131231',
      '31241012',
      '30222402',
      '24400140',
      '24101310',
      NULL,
      '41420013',
      '02042430',
      NULL,
      '03243040',
      NULL,
      '23200112',
      '33142000',
      '32144342',
      '21232133',
      NULL,
      '02343202',
      '00100440',
      '30313233',
      '24314323',
      '02414434',
      '11244104',
      '40021044',
      '12202021',
      '12030110',
      '40144200',
      '31241312',
      '20231313',
      '04341241',
      '23404412',
      '03104132',
      '10204121',
      '42421144',
      NULL,
      '32',
      22.950208,
      2.514986,
      '3243241',
      1.639543,
      8,
      1,
      NULL,
      '134013',
      1.592965,
      '11-28-2001',
      '11- 6-1986',
      57,
      43,
      25.109813,
      8,
      12,
      14.030585,
      NULL,
      10,
      25.084359,
      7.730722,
      19.109991,
      7.763437,
      26.262915,
      NULL,
      1.182533,
      10,
      12.168652,
      1.358086,
      5,
      NULL,
      58,
      8,
      80.821780,
      NULL,
      0,
      32,
      179,
      61,
      1,
      61,
      125,
      ' 9-10-1993',
      21,
      65.524436,
      15.817305,
      NULL,
      98.660525,
      99,
      '10- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      9,
      NULL,
      ' 8-15-1978',
      1.190983,
      1,
      67.440867,
      1,
      1,
      57,
      NULL,
      NULL,
      44.405571,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      45,
      NULL,
      33.495803,
      5.776274,
      4.236990,
      46.359262,
      26,
      33,
      55.168122,
      55.473788,
      ' 7- 2-1981',
      7,
      10.083917,
      NULL,
      62,
      97.891026,
      190.548679,
      15,
      ' 8-26-1988',
      16,
      2,
      ' 7-22-2002',
      8,
      15,
      8.522441,
      16,
      18,
      0,
      NULL,
      0.091715,
      NULL,
      45.720887,
      6,
      1,
      0.980530,
      21,
      1,
      5,
      4,
      3.113692,
      '11- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      2.107686,
      ' 0- 0-1978',
      NULL,
      NULL,
      NULL,
      12.436878,
      ' 8- 9-1991',
      51.510250,
      ' 5-15-1981',
      11,
      15.525393,
      ' 4- 8-1998',
      75,
      NULL,
      ' 7- 4-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      7.823617,
      ' 7- 9-1979',
      NULL,
      NULL,
      10,
      '10- 7-1982',
      1.578233,
      27,
      NULL,
      5.778304,
      NULL,
      0,
      22,
      NULL,
      NULL,
      0.114679,
      105.221478,
      ' 5-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


