set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '0',
      '4',
      '3',
      '4',
      '3',
      '0',
      '4',
      '3',
      '4',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '3',
      '1',
      '2',
      '4',
      '2',
      '1',
      '2',
      '4',
      '',
      '3',
      '',
      '1',
      NULL,
      '1',
      NULL,
      '3',
      '',
      '',
      '4',
      '3',
      '3',
      '4',
      NULL,
      '3',
      '2',
      '3',
      '1',
      '4',
      NULL,
      '204',
      NULL,
      NULL,
      68,
      NULL,
      NULL,
      194,
      0,
      0,
      '432331',
      3.774748,
      ' 2- 4-1985',
      ' 7-12-1974',
      80.219304,
      23,
      8.094153,
      20.874866,
      22,
      0,
      12,
      17,
      16,
      11,
      7.204451,
      NULL,
      3,
      3.084292,
      NULL,
      12,
      NULL,
      6,
      14,
      15.589876,
      39,
      16,
      19.201370,
      7,
      1.501116,
      79,
      NULL,
      54,
      83,
      61.995416,
      151,
      NULL,
      NULL,
      8,
      28,
      0.158624,
      127,
      144,
      ' 5- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951430,
      1.586049,
      NULL,
      1,
      0.987916,
      0.230801,
      3,
      0.077977,
      2.533727,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      99,
      46,
      51.738699,
      115.694736,
      20,
      77.723815,
      NULL,
      15.863933,
      56.541542,
      NULL,
      28.830139,
      ' 9- 6-1987',
      8.402777,
      NULL,
      14.034247,
      31.584587,
      41,
      0.931360,
      NULL,
      ' 5-22-1991',
      21.105010,
      12,
      ' 3-25-1980',
      NULL,
      5.012699,
      0.032440,
      13,
      2.024927,
      5.899252,
      1.553709,
      NULL,
      0.176436,
      67.342243,
      2.983248,
      0.373711,
      17,
      16,
      NULL,
      NULL,
      5.110772,
      NULL,
      ' 5- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      186,
      13,
      ' 6-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 6-2003',
      38.360494,
      ' 8-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 6-25-1994',
      52,
      2,
      3.397048,
      NULL,
      1.503203,
      53,
      NULL,
      8.786530,
      16.061259,
      13.507075,
      NULL,
      NULL,
      30,
      0.677694,
      65,
      ' 6-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


