set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '0',
      '4',
      '1',
      '4',
      NULL,
      '3',
      NULL,
      '0',
      NULL,
      '2',
      '0',
      '4',
      '0',
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      '3',
      '',
      '2',
      '',
      '3',
      NULL,
      NULL,
      '0',
      NULL,
      '',
      '',
      '2',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '0',
      '1',
      '4',
      '4',
      NULL,
      '304',
      '32322342',
      NULL,
      30,
      '3224441',
      3.921273,
      1.529402,
      2,
      1,
      '202212',
      0,
      ' 7-11-1997',
      ' 2- 9-1975',
      NULL,
      NULL,
      7.139940,
      NULL,
      16.625828,
      10.928414,
      29.172087,
      5,
      22,
      NULL,
      11,
      1,
      13.683943,
      8.986920,
      11.147878,
      7.376884,
      NULL,
      NULL,
      NULL,
      4.337699,
      38,
      9,
      28.712391,
      2.815699,
      0,
      NULL,
      40,
      NULL,
      116,
      124.840352,
      25,
      ' 0-17-1995',
      NULL,
      26.123493,
      15.728032,
      4.741754,
      177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75.265683,
      12.544010,
      35.200671,
      NULL,
      26.492073,
      3.199111,
      NULL,
      0.971429,
      0.437482,
      158,
      3,
      0.360892,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1990',
      57.540920,
      47.220511,
      71,
      45,
      82.925763,
      57.882413,
      NULL,
      18,
      42.422215,
      3.006855,
      21.291805,
      31,
      ' 5-20-2001',
      7.715378,
      9,
      NULL,
      6,
      32.901701,
      NULL,
      NULL,
      '10-12-1981',
      13,
      NULL,
      ' 0-29-1982',
      NULL,
      3,
      21.956608,
      7.780733,
      5,
      NULL,
      0.365849,
      8.873036,
      0,
      55,
      0,
      1.940000,
      8,
      NULL,
      0.192810,
      0.056583,
      0,
      0,
      ' 4-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      '10-21-1981',
      1.101805,
      NULL,
      4.348021,
      12,
      NULL,
      26,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 8-20-2003',
      38.335908,
      NULL,
      7,
      '10-13-1984',
      1,
      33.494898,
      ' 1-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


