set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1434',
      '22232414',
      NULL,
      '23001110',
      '02223312',
      '40401010',
      '12011300',
      '13321224',
      NULL,
      '30002123',
      '10233234',
      '34410043',
      '11444101',
      '21124302',
      '13200222',
      '21321242',
      '33134420',
      NULL,
      '14240142',
      '42140301',
      '43334440',
      '44402310',
      NULL,
      '11123441',
      '03303220',
      '12241200',
      '32300344',
      '44143220',
      NULL,
      '11113331',
      '11240213',
      NULL,
      '02113302',
      '23314333',
      '12343132',
      '10143213',
      '13114242',
      NULL,
      NULL,
      '12300434',
      '41200021',
      '12114202',
      '43444303',
      NULL,
      '23434020',
      NULL,
      '12',
      NULL,
      NULL,
      NULL,
      1.847881,
      0,
      1,
      NULL,
      '130030',
      3,
      ' 6- 7-1994',
      ' 2- 7-1987',
      60,
      NULL,
      4.571454,
      0,
      NULL,
      3.129741,
      87,
      7.306659,
      23.132996,
      10,
      13,
      1,
      29.850923,
      12.741814,
      7,
      5,
      10,
      17.190908,
      52.668744,
      2.252221,
      52,
      5,
      NULL,
      0.184774,
      1.318112,
      14,
      NULL,
      99,
      69.413802,
      125,
      70.564548,
      ' 3- 9-1985',
      32,
      53,
      13,
      34,
      144.954002,
      125.891402,
      ' 4- 2-1980',
      1.108662,
      1.726400,
      4.921537,
      NULL,
      5.713554,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.261593,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.035203,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-22-1983',
      28,
      28.595830,
      0.074620,
      21,
      2,
      4,
      '10-28-1981',
      1,
      3,
      0.801393,
      1,
      0.156243,
      NULL,
      1,
      1.279062,
      25.650962,
      1.475154,
      1,
      NULL,
      ' 7-28-1974',
      NULL,
      89.181375,
      17,
      5,
      70,
      18.978965,
      NULL,
      33.210959,
      45.909997,
      7.421796,
      47.002006,
      64,
      ' 0-23-1982',
      23.662925,
      2,
      5,
      29,
      66,
      18.389709,
      7,
      ' 4-18-1979',
      7.915661,
      NULL,
      ' 8-12-1987',
      13.017262,
      17,
      25.598161,
      24,
      14,
      2.851596,
      1.512178,
      6,
      NULL,
      18.118727,
      NULL,
      3.910835,
      9,
      29,
      2,
      1.117254,
      0,
      3,
      ' 8- 7-1996',
      NULL,
      5,
      0,
      ' 0-15-1996',
      56,
      20.720398,
      ' 5- 6-1995',
      NULL,
      NULL,
      NULL,
      31,
      ' 3-27-1987',
      23,
      ' 0- 2-2000',
      5,
      16.331843,
      ' 5-23-1983',
      NULL,
      NULL,
      '11-16-1983',
      NULL,
      11.134589,
      ' 2-10-1988',
      2.702916,
      8.754832,
      ' 2- 8-1985',
      3,
      NULL,
      16,
      ' 0- 3-2000',
      68,
      16.593216,
      2.247476,
      ' 7- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


