set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8234935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '2',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '1',
      '3',
      '1',
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '0',
      '0',
      '',
      '2',
      '',
      '4',
      '1',
      '2',
      NULL,
      NULL,
      '',
      '',
      '1',
      NULL,
      '4',
      '0',
      NULL,
      '2',
      '4',
      '1',
      NULL,
      '2',
      '4',
      '243',
      '01323041',
      86.032448,
      78,
      NULL,
      3,
      0,
      0,
      1,
      '124343',
      0.555995,
      NULL,
      '10-14-1984',
      NULL,
      46,
      19.871501,
      1.789185,
      21.093130,
      NULL,
      99,
      0,
      13,
      6.678041,
      21,
      NULL,
      NULL,
      NULL,
      27.931197,
      12,
      0.985390,
      3,
      0,
      4,
      NULL,
      NULL,
      51.029459,
      24,
      1,
      56,
      NULL,
      NULL,
      71,
      NULL,
      163.980046,
      ' 9- 4-1994',
      11.379977,
      1.859817,
      NULL,
      14.222908,
      191,
      53,
      ' 2- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      14.150293,
      14.129968,
      14,
      8.549249,
      6.810057,
      ' 8-22-1999',
      1.238539,
      1.100532,
      134.506603,
      1.590592,
      1.017285,
      NULL,
      0,
      0.034985,
      16.518707,
      NULL,
      NULL,
      NULL,
      ' 0-24-1976',
      67,
      16.598056,
      19.875967,
      24,
      23.444270,
      23,
      37.793471,
      36.685391,
      18.158715,
      89,
      NULL,
      3.909611,
      '11-25-1987',
      9,
      26,
      NULL,
      65.419121,
      NULL,
      43.559989,
      7,
      ' 3-17-2000',
      10.561924,
      25,
      ' 2-26-2002',
      5,
      19.566987,
      10,
      NULL,
      11.821695,
      6.867169,
      1,
      19.028981,
      0.337511,
      30.498410,
      0.359618,
      0,
      15,
      7,
      1.782608,
      NULL,
      0.746280,
      0.504564,
      ' 4- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1989',
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      25,
      '10-22-2002',
      15.096456,
      NULL,
      ' 3-14-1975',
      121,
      24.063313,
      ' 9- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      15.731867,
      '10- 4-1998',
      9.125088,
      3.835291,
      3.661939,
      ' 7-26-1989',
      0,
      107.166402,
      '11-29-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


