set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0109264';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      '3',
      '0',
      '0',
      '4',
      '1',
      '3',
      NULL,
      '2',
      '1',
      '3',
      '1',
      '2',
      '4',
      '2',
      '1',
      '2',
      '0',
      '2',
      NULL,
      NULL,
      '0',
      '',
      NULL,
      '',
      '2',
      '1',
      '2',
      '0',
      '0',
      '',
      '',
      '1',
      NULL,
      '3',
      '1',
      '0',
      '4',
      '2',
      NULL,
      NULL,
      '0',
      '3',
      '310',
      NULL,
      60.275986,
      49,
      '4303323',
      0.729908,
      1.527278,
      2,
      0,
      '341330',
      6,
      ' 2- 9-2002',
      ' 5-29-1981',
      14,
      85,
      44.867769,
      18,
      23.987049,
      18.677012,
      NULL,
      0,
      28,
      3.827667,
      36.879744,
      NULL,
      30,
      3.789512,
      NULL,
      6.623744,
      19.422323,
      16.720142,
      26,
      11.089286,
      NULL,
      17,
      NULL,
      24,
      0,
      117.257651,
      202.472126,
      11.428938,
      221.624676,
      37,
      193.355033,
      ' 7-22-2000',
      38.141760,
      19.110120,
      26,
      27,
      127.749929,
      44,
      ' 9-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.226656,
      13.952118,
      8,
      6,
      0.074173,
      9,
      ' 7-15-1982',
      1.733132,
      0,
      183.644727,
      0,
      0.099305,
      NULL,
      0.340496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1976',
      21,
      91.683222,
      42,
      85.498370,
      62.195487,
      28,
      106,
      97.969563,
      NULL,
      NULL,
      NULL,
      58,
      NULL,
      5.642917,
      NULL,
      2.656167,
      90.988560,
      NULL,
      40,
      3,
      ' 2- 6-1979',
      32,
      31.435287,
      '10-22-1999',
      8.190216,
      NULL,
      11.592426,
      8,
      7,
      7,
      1.100529,
      21,
      0.747839,
      24,
      1,
      1,
      7.069947,
      NULL,
      0,
      1.293087,
      1.353910,
      NULL,
      ' 9- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      134,
      6.727639,
      ' 5-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1977',
      40,
      ' 2- 7-1984',
      NULL,
      NULL,
      ' 9- 3-2003',
      176.187361,
      NULL,
      ' 3-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.409609,
      ' 7-21-1978',
      10,
      39,
      NULL,
      ' 9- 0-1989',
      1.299926,
      4,
      ' 2- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


