set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9306586';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1040',
      NULL,
      '33203401',
      '10114322',
      '20400311',
      '14342412',
      '12221332',
      NULL,
      NULL,
      '10021401',
      '42010311',
      '30204124',
      NULL,
      '20131241',
      '04301442',
      '11121403',
      '42412310',
      '20243100',
      NULL,
      '42142200',
      '12040031',
      NULL,
      '43432431',
      '01142432',
      '23033012',
      NULL,
      '13233023',
      '13202244',
      '34141323',
      '02001044',
      '30230314',
      '13203214',
      '11222321',
      '32024040',
      '21204234',
      '14112233',
      '40213441',
      '04104441',
      '33001441',
      NULL,
      NULL,
      '02022402',
      NULL,
      '33243131',
      '34232320',
      '233',
      NULL,
      NULL,
      NULL,
      '2023121',
      0.333728,
      0.873665,
      0,
      NULL,
      '303412',
      0.597472,
      NULL,
      ' 3- 6-2003',
      58.769114,
      NULL,
      NULL,
      NULL,
      39,
      25,
      45.847816,
      2,
      4.569649,
      23.815100,
      11,
      4,
      1,
      NULL,
      33,
      20.975016,
      29,
      2.048849,
      72.900716,
      23,
      24.214323,
      15,
      NULL,
      5,
      0.830612,
      85.623105,
      30.959180,
      NULL,
      NULL,
      50,
      101.219970,
      ' 9-24-1996',
      44.818975,
      66.532796,
      16.974674,
      34,
      118.870321,
      214.003895,
      ' 2-29-1990',
      0.561756,
      0.632358,
      0,
      1,
      0.244454,
      1,
      0,
      1,
      NULL,
      NULL,
      0.394748,
      1.795501,
      1,
      0,
      0.128387,
      NULL,
      1,
      1.362019,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1992',
      48.681887,
      NULL,
      0.315928,
      13.019195,
      NULL,
      NULL,
      '11-12-1993',
      NULL,
      NULL,
      NULL,
      2,
      0,
      162,
      1.687185,
      NULL,
      102,
      1.898229,
      NULL,
      262,
      ' 3- 3-2001',
      29.351020,
      104.675347,
      23,
      7,
      18,
      71.775658,
      95,
      109,
      60,
      22.861410,
      70,
      89.887794,
      NULL,
      26,
      19,
      7,
      36.849034,
      32,
      NULL,
      6,
      '11-15-1983',
      17,
      9,
      ' 5- 6-2001',
      6,
      10.347423,
      11,
      10.889384,
      NULL,
      3.935851,
      1,
      NULL,
      0,
      31,
      1.327261,
      NULL,
      21,
      14,
      0,
      1,
      NULL,
      1,
      ' 7- 4-2003',
      4,
      2,
      2,
      ' 3- 0-1998',
      263.961852,
      1.915398,
      ' 8- 3-1975',
      36.557291,
      1.552738,
      ' 2-16-2003',
      22,
      ' 5-14-2001',
      NULL,
      ' 0-21-1991',
      19.367950,
      NULL,
      ' 6-25-1990',
      56.245168,
      NULL,
      NULL,
      1.184133,
      8,
      '10-25-1998',
      0,
      2.810636,
      NULL,
      0,
      NULL,
      5,
      ' 3-29-1983',
      49,
      17,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.122404);
commit;
end;
/


