set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '4',
      '1',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      '4',
      NULL,
      '4',
      '3',
      '3',
      '',
      '3',
      '',
      '2',
      '3',
      '1',
      NULL,
      '1',
      '',
      '',
      NULL,
      '3',
      '2',
      '2',
      '3',
      '3',
      '3',
      '3',
      '1',
      '2',
      '0',
      '032',
      '12401012',
      9,
      22,
      NULL,
      NULL,
      4,
      2,
      NULL,
      '022233',
      2,
      ' 6-24-2000',
      ' 1-29-1977',
      NULL,
      118,
      NULL,
      5.649804,
      15.261494,
      11,
      59,
      4.747035,
      5,
      2.317225,
      3.634548,
      6.153505,
      16.755618,
      2,
      23,
      2,
      2.716448,
      NULL,
      17.155878,
      10,
      34,
      5.406291,
      16.839627,
      6,
      1.793522,
      32.785597,
      0.995482,
      NULL,
      32.921887,
      22.230347,
      128,
      ' 9-20-1977',
      11.082984,
      18,
      17.412841,
      15.167681,
      140.392093,
      11,
      ' 9-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      1.586096,
      60,
      0.008944,
      '10-16-2001',
      1,
      1.331141,
      6.699883,
      0.603310,
      1,
      NULL,
      0.197491,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-2002',
      99,
      NULL,
      13,
      7,
      NULL,
      0.275013,
      NULL,
      9.652252,
      23.256758,
      29.522214,
      51.959835,
      NULL,
      ' 9-27-1993',
      6.576578,
      0.584175,
      14.391057,
      NULL,
      0,
      5,
      0,
      ' 1-18-1990',
      1,
      NULL,
      ' 7- 6-1986',
      NULL,
      3,
      10.058966,
      6,
      1.682189,
      1,
      0,
      3,
      0.314067,
      7.965822,
      0.966309,
      1.934577,
      1.635242,
      0.951849,
      25,
      2.286178,
      0,
      NULL,
      ' 0-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.367056,
      ' 9-14-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1988',
      42,
      ' 5-23-2003',
      9,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      18.040245,
      ' 0-16-1981',
      NULL,
      22,
      NULL,
      ' 3-13-1991',
      0.459097,
      NULL,
      ' 4- 4-1997',
      3,
      88,
      NULL,
      NULL,
      ' 2-25-1989',
      0,
      0,
      30,
      ' 1-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


