set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '1',
      '3',
      '2',
      NULL,
      NULL,
      '2',
      '4',
      '0',
      '4',
      '4',
      '4',
      NULL,
      '3',
      '4',
      '0',
      '2',
      '2',
      '0',
      '',
      '4',
      NULL,
      NULL,
      '3',
      '2',
      '0',
      '2',
      '',
      '',
      '0',
      '2',
      '0',
      '1',
      '0',
      '2',
      '1',
      '2',
      '0',
      '4',
      NULL,
      '013',
      NULL,
      35.018121,
      87.195132,
      NULL,
      2,
      NULL,
      1,
      1,
      '124140',
      2,
      NULL,
      ' 3-26-1993',
      42,
      34.947538,
      6.568029,
      2,
      5,
      5.320793,
      NULL,
      4,
      9.774222,
      1.313200,
      NULL,
      10.053075,
      NULL,
      2,
      17.725737,
      2,
      3.341284,
      4,
      2.566327,
      7,
      22.219766,
      3,
      10.336797,
      2.954440,
      NULL,
      34,
      121.870451,
      23,
      106.560391,
      87.089159,
      NULL,
      ' 1-19-1996',
      4,
      4,
      29.112898,
      1.356697,
      NULL,
      NULL,
      ' 1-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      52,
      35.048238,
      NULL,
      42.332003,
      0,
      '10-27-1990',
      0.527789,
      NULL,
      93,
      1.636982,
      0,
      46,
      8,
      0.741507,
      7,
      NULL,
      NULL,
      NULL,
      '11-27-1984',
      NULL,
      76,
      42,
      59.353233,
      42,
      90.453190,
      95.478661,
      90,
      21.653390,
      69,
      48,
      70,
      ' 3- 8-1991',
      5,
      9,
      3.717485,
      5.911617,
      NULL,
      1.821539,
      2.946236,
      ' 2- 2-1986',
      3,
      0,
      '10- 2-1993',
      1.111784,
      5,
      NULL,
      3.816724,
      0,
      0.675651,
      0,
      1.907893,
      1.522427,
      18,
      NULL,
      1.327356,
      0.444269,
      10,
      7.813485,
      6.582140,
      1,
      NULL,
      '10-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      ' 6- 9-2003',
      NULL,
      NULL,
      NULL,
      35.381660,
      NULL,
      9,
      ' 6-18-1980',
      9.504504,
      NULL,
      '11-13-1977',
      96.889949,
      39.681524,
      ' 5- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 2- 1-1994',
      13,
      25,
      0.572492,
      '10-22-1981',
      NULL,
      NULL,
      NULL,
      0.950003,
      94,
      10,
      66,
      ' 9-26-1984',
      NULL,
      0,
      140.654458,
      ' 0-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


