set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0122',
      '40340012',
      '44131013',
      '30410431',
      NULL,
      '44332033',
      '13342144',
      '32143203',
      '44320023',
      '14331131',
      NULL,
      NULL,
      '42241130',
      '00222131',
      '43404303',
      NULL,
      '14424230',
      '01233113',
      '21020420',
      '03131401',
      NULL,
      '23243430',
      '44332144',
      '10002334',
      '43342001',
      '44434324',
      '30442033',
      '13043334',
      '21424030',
      '41222330',
      '04022013',
      '30033044',
      '14002321',
      '04334421',
      NULL,
      NULL,
      NULL,
      '32312011',
      '32313112',
      '33002120',
      '41313412',
      '22324112',
      NULL,
      '04120233',
      '10434034',
      '234',
      '30',
      NULL,
      NULL,
      '3110141',
      NULL,
      NULL,
      2,
      NULL,
      '302404',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7.581212,
      NULL,
      14.492816,
      38,
      4.517505,
      15.211515,
      12.653058,
      11,
      4,
      22,
      9.974216,
      10.589481,
      1,
      18.468778,
      11,
      5.704239,
      9,
      4,
      11.945591,
      7,
      6,
      1,
      21.297714,
      139,
      47,
      132,
      NULL,
      2.655570,
      NULL,
      35,
      19.319581,
      9,
      20,
      185,
      186,
      ' 8- 7-1980',
      1,
      6.061324,
      3.346104,
      4,
      1,
      6.517389,
      1,
      NULL,
      1,
      0.538741,
      7,
      0,
      0,
      NULL,
      0.531853,
      NULL,
      3,
      1.317547,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1975',
      40.848939,
      NULL,
      0,
      7.822571,
      1.413610,
      0,
      ' 1-17-1987',
      0.546990,
      2,
      125,
      1,
      0.261040,
      82,
      3.097586,
      0,
      42.099386,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      96.173246,
      73,
      3,
      100,
      67,
      92.802193,
      12.872845,
      66.531499,
      26.087898,
      24.640153,
      72,
      ' 2-19-1978',
      NULL,
      13.671913,
      NULL,
      9,
      11,
      0,
      NULL,
      ' 2- 7-1998',
      12.266674,
      4,
      '10- 5-1993',
      8.473476,
      6,
      13,
      7.486993,
      1,
      NULL,
      0.201690,
      6.037586,
      0.217079,
      22,
      2,
      2,
      9.287558,
      8,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.142633,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      30.611759,
      ' 6- 9-1985',
      0,
      ' 1-26-1974',
      4,
      1,
      ' 1-10-1975',
      15,
      11.993001,
      ' 4- 8-1996',
      NULL,
      2.645491,
      ' 0- 1-1974',
      NULL,
      NULL,
      NULL,
      3,
      1,
      25.769773,
      ' 5-29-1992',
      50.525043,
      5,
      5.473133,
      ' 3- 2-1978',
      1.910101,
      NULL,
      ' 0- 4-1974',
      12.253882,
      19,
      6,
      NULL,
      NULL,
      60,
      0.019091,
      24,
      '11-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


