set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '1',
      '3',
      '1',
      '3',
      '0',
      '2',
      '0',
      '1',
      '1',
      '2',
      NULL,
      '2',
      '4',
      '2',
      '2',
      '1',
      '1',
      NULL,
      '3',
      '2',
      '4',
      NULL,
      '',
      '4',
      '',
      '2',
      '4',
      '4',
      '0',
      '3',
      NULL,
      '',
      '4',
      '4',
      '0',
      '0',
      '1',
      '1',
      '3',
      NULL,
      '2',
      NULL,
      '0',
      '402',
      '24320121',
      11.516208,
      10.955661,
      '2432341',
      0,
      97,
      2,
      NULL,
      NULL,
      5,
      ' 0-18-1985',
      NULL,
      14,
      NULL,
      0,
      NULL,
      21,
      14.606148,
      12.504095,
      2,
      4,
      NULL,
      2.431197,
      NULL,
      13.039492,
      NULL,
      18,
      10.089018,
      NULL,
      3.230031,
      14,
      1,
      24,
      0,
      3,
      0,
      1,
      1,
      39,
      46.304727,
      134.803192,
      87,
      154,
      '10-11-2000',
      5,
      NULL,
      NULL,
      19,
      64,
      180,
      ' 2-13-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79.549743,
      NULL,
      7,
      5.478098,
      2,
      NULL,
      ' 3-10-1988',
      0,
      NULL,
      159.142302,
      NULL,
      1.675562,
      25.586161,
      NULL,
      2.209693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      13,
      44,
      64,
      49.862770,
      8.570744,
      NULL,
      55.156067,
      69.398872,
      2.855583,
      81.482365,
      ' 7-24-1975',
      3,
      7.969774,
      4,
      11,
      38.355277,
      NULL,
      0,
      NULL,
      10.400505,
      7.638334,
      ' 5-28-1995',
      14,
      NULL,
      13,
      NULL,
      7,
      3,
      1.348042,
      11,
      NULL,
      30.925892,
      NULL,
      1,
      5.216665,
      NULL,
      1,
      5,
      NULL,
      0.114553,
      ' 4-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      144.617199,
      NULL,
      '11- 3-2002',
      NULL,
      NULL,
      NULL,
      5.442715,
      ' 7- 7-1976',
      21.379034,
      '11- 2-1974',
      7.848727,
      11,
      ' 4-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      '11-25-1984',
      9,
      2,
      NULL,
      ' 9- 6-1996',
      0,
      9,
      ' 1- 2-1997',
      1,
      21.644520,
      18.156339,
      NULL,
      ' 5- 2-1992',
      70.512460,
      0.808978,
      NULL,
      ' 5- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


