set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '0',
      '0',
      '2',
      '4',
      '2',
      '3',
      NULL,
      '2',
      '0',
      '2',
      '3',
      '2',
      '1',
      '1',
      NULL,
      '3',
      '3',
      '3',
      '4',
      '4',
      '4',
      '1',
      '',
      '1',
      '',
      '2',
      '4',
      '2',
      '4',
      '0',
      '',
      NULL,
      '4',
      '1',
      '2',
      NULL,
      '3',
      NULL,
      '4',
      '1',
      NULL,
      '0',
      '0',
      '041',
      '20133122',
      56.412905,
      NULL,
      '3110424',
      1.972601,
      1.106811,
      0,
      NULL,
      '024402',
      0.358896,
      ' 3- 5-1999',
      '11-27-1975',
      NULL,
      250.787880,
      25,
      NULL,
      2.175409,
      NULL,
      NULL,
      11.957674,
      2,
      7.176476,
      NULL,
      10.713796,
      15.183871,
      12.971427,
      NULL,
      17.012309,
      4,
      11,
      11.781945,
      15,
      6.153433,
      7.738072,
      4.621428,
      4,
      1.536679,
      NULL,
      108.100127,
      16,
      NULL,
      89,
      NULL,
      ' 6-18-1989',
      44,
      36.152802,
      9.033885,
      16.771395,
      79,
      175,
      ' 9-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      17.976962,
      17,
      21.715085,
      NULL,
      ' 2-28-1990',
      NULL,
      0.746769,
      76,
      0.277358,
      NULL,
      72.446408,
      0,
      1,
      23,
      NULL,
      NULL,
      NULL,
      ' 6-19-1977',
      30,
      57.060129,
      NULL,
      3.622761,
      24.134947,
      63,
      75,
      85,
      NULL,
      43,
      NULL,
      77.470839,
      ' 6-29-2002',
      7.056918,
      22,
      NULL,
      45.488771,
      36.134525,
      8.147280,
      10,
      ' 7-14-2000',
      NULL,
      8.610607,
      NULL,
      4.128589,
      8.533747,
      18.311755,
      2,
      5.512538,
      7.528644,
      0,
      8,
      1,
      70.940066,
      NULL,
      NULL,
      10.139507,
      9.870394,
      0.755057,
      1.553509,
      1.358602,
      0,
      ' 6- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      29.063809,
      29,
      ' 1- 0-1977',
      NULL,
      NULL,
      NULL,
      44,
      ' 9-10-1976',
      NULL,
      ' 2- 5-1985',
      8,
      2,
      NULL,
      32.349367,
      38.770306,
      ' 4-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      '11-11-1999',
      4.157186,
      25.870230,
      22.856059,
      ' 8-28-1984',
      0.758183,
      11,
      NULL,
      5,
      NULL,
      2.772942,
      NULL,
      ' 3- 8-1982',
      10.090958,
      NULL,
      NULL,
      ' 4-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


