set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '1',
      '0',
      '0',
      '0',
      '1',
      '2',
      '3',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '1',
      '2',
      NULL,
      '3',
      '4',
      '0',
      '3',
      '0',
      '',
      '0',
      '',
      '3',
      '2',
      NULL,
      NULL,
      '3',
      '',
      '',
      '3',
      '1',
      '2',
      '3',
      '4',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      '024',
      NULL,
      71.662174,
      51,
      NULL,
      2,
      24,
      3,
      0,
      '312112',
      3.457927,
      ' 9-28-1989',
      NULL,
      38,
      247.254350,
      8,
      7.567081,
      23,
      NULL,
      19.780535,
      2,
      NULL,
      2,
      NULL,
      2,
      10,
      4,
      6,
      9,
      18,
      7,
      NULL,
      10,
      44.030761,
      8.497458,
      64,
      NULL,
      1.749020,
      7,
      155,
      NULL,
      107.671873,
      119,
      NULL,
      ' 8-21-1990',
      10,
      17.874608,
      22.406709,
      23,
      84,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.708283,
      31.250947,
      NULL,
      15,
      NULL,
      2,
      ' 8-22-1986',
      0,
      0,
      123.962811,
      0,
      0,
      71.433590,
      1,
      NULL,
      8.501602,
      NULL,
      NULL,
      NULL,
      ' 4- 0-1997',
      9,
      43.286826,
      32,
      16,
      11.801586,
      55.133314,
      9,
      NULL,
      34.946337,
      54.632774,
      21.372973,
      26,
      ' 0-12-2003',
      14,
      8.041551,
      15.728300,
      NULL,
      39,
      20,
      2.192065,
      '11-16-1980',
      9,
      2,
      ' 8-16-2001',
      0,
      11.618626,
      7.394730,
      NULL,
      4,
      1.172408,
      1.579076,
      NULL,
      0.772060,
      52,
      0,
      NULL,
      5.230974,
      3,
      0.690761,
      1.579918,
      0,
      1.806651,
      ' 9-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      114.900461,
      0,
      '10- 2-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1984',
      17.464928,
      NULL,
      12,
      7,
      ' 5-12-1974',
      38,
      76,
      ' 9-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.425887,
      NULL,
      NULL,
      30.355946,
      48,
      ' 8- 5-2002',
      1.856996,
      56.231089,
      ' 7- 7-1992',
      3,
      149.985326,
      6.580182,
      87.754062,
      ' 8-10-1986',
      46.852522,
      0,
      NULL,
      ' 0-13-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


