set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702192';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0233',
      NULL,
      '00220423',
      '00033441',
      '13022321',
      '02213414',
      NULL,
      '31031122',
      NULL,
      '42103200',
      '20044421',
      NULL,
      '24200222',
      '31110423',
      NULL,
      NULL,
      NULL,
      '02404330',
      '43414311',
      '43424001',
      '14343213',
      '41004040',
      '11010404',
      '01041200',
      '00330411',
      '02423040',
      '21104433',
      '01043023',
      '13144302',
      '22033102',
      '02434020',
      NULL,
      '04022044',
      '34301410',
      '23022114',
      '42223233',
      '13341101',
      '40242041',
      '42044103',
      '01201441',
      '41323422',
      NULL,
      '12100033',
      NULL,
      '21111312',
      NULL,
      '03',
      NULL,
      NULL,
      '3444214',
      0.065200,
      1,
      3,
      NULL,
      '343111',
      4.002658,
      ' 6-16-1996',
      ' 0- 4-1990',
      98,
      NULL,
      5,
      5.655492,
      14,
      4,
      15,
      10,
      9.319368,
      9,
      NULL,
      7,
      6.318352,
      NULL,
      20,
      2,
      10,
      10.572293,
      39.684161,
      13.332449,
      13.071480,
      10.232114,
      NULL,
      3.826846,
      NULL,
      4.703981,
      1,
      NULL,
      34.811486,
      NULL,
      10.288726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      137.425245,
      0,
      0.135253,
      74.481831,
      1,
      0.300039,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.498991,
      7.547805,
      NULL,
      10,
      NULL,
      NULL,
      3,
      ' 3-13-1985',
      0,
      0.796381,
      ' 4-16-1976',
      NULL,
      0,
      NULL,
      8.618573,
      0.221604,
      8.313776,
      0.031547,
      NULL,
      1,
      30,
      NULL,
      2.546264,
      7.689847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807691,
      1.163438,
      '10- 4-2002',
      NULL,
      NULL,
      ' 3- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-2003',
      42.341328,
      ' 0- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.360331,
      ' 8-23-1987',
      6,
      6,
      ' 8- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      6.529962,
      26,
      36.837381,
      ' 2-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


