set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1323',
      NULL,
      '14443010',
      '01221223',
      '20224244',
      '23210412',
      NULL,
      NULL,
      NULL,
      '40211124',
      '42101000',
      NULL,
      '41434001',
      '14410113',
      '04404120',
      '12334400',
      NULL,
      '14440132',
      '33002021',
      NULL,
      '20310331',
      '04230041',
      '34200424',
      NULL,
      '03021403',
      '23022401',
      '30400423',
      '03011244',
      '22414402',
      '21334211',
      '14340304',
      '44020221',
      NULL,
      '10311044',
      '41324442',
      '11230343',
      '02410022',
      '22444204',
      NULL,
      '21214133',
      '10301243',
      '22034212',
      '42044324',
      '21003134',
      '04043223',
      '341',
      '43',
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '312331',
      2.605552,
      ' 7- 4-1978',
      ' 9- 8-1990',
      18,
      21.208153,
      NULL,
      18,
      29.483832,
      11.367101,
      11.569093,
      8,
      NULL,
      NULL,
      17.728221,
      5.734837,
      1.861642,
      13,
      11.241930,
      10,
      5.035560,
      9,
      42.075843,
      0,
      NULL,
      8.048506,
      NULL,
      19.352711,
      0,
      NULL,
      141.339245,
      40,
      72,
      172,
      NULL,
      NULL,
      24,
      13,
      4,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.373141,
      NULL,
      2.440534,
      19,
      NULL,
      5.788146,
      ' 1-22-1988',
      1.630301,
      5.387885,
      37.974530,
      1,
      4.068543,
      42.072363,
      NULL,
      1.653622,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-1993',
      26.940370,
      2,
      NULL,
      1.304415,
      NULL,
      NULL,
      30.699730,
      NULL,
      4,
      57,
      6,
      NULL,
      ' 7-27-1984',
      21.727539,
      6,
      7,
      NULL,
      26,
      NULL,
      2.757414,
      '10-20-1994',
      21.965646,
      NULL,
      ' 6-27-1983',
      10.337010,
      14.038763,
      7.575137,
      1,
      10.104027,
      2.187017,
      NULL,
      9,
      0.134126,
      76,
      1.527687,
      NULL,
      3.077388,
      NULL,
      NULL,
      2,
      NULL,
      0.176120,
      ' 0- 0-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      35.704677,
      '11-10-1974',
      9.620862,
      ' 5-14-1982',
      0.789923,
      10.696859,
      ' 2-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      20,
      15.432412,
      ' 5-14-2002',
      0.191058,
      56,
      ' 6-28-1983',
      17,
      2.274718,
      NULL,
      2.365547,
      ' 4-18-2000',
      2,
      NULL,
      NULL,
      '10- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


