set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '1',
      '4',
      '2',
      '2',
      '4',
      '4',
      NULL,
      '1',
      '2',
      '2',
      '4',
      '2',
      '0',
      '4',
      NULL,
      '4',
      '1',
      '4',
      '4',
      '3',
      '1',
      '0',
      '',
      '2',
      '',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '',
      '',
      NULL,
      '0',
      '4',
      '3',
      '3',
      '1',
      '0',
      '4',
      NULL,
      '2',
      NULL,
      '101',
      '22002433',
      NULL,
      60.516939,
      '1304111',
      3,
      42,
      3,
      NULL,
      '301330',
      2.172473,
      ' 4-22-1981',
      ' 6-24-1980',
      63.674855,
      120,
      19.359542,
      NULL,
      23.996242,
      NULL,
      40,
      19,
      1.031032,
      19,
      7,
      13,
      37,
      10,
      27,
      13,
      NULL,
      14.611056,
      11,
      6,
      37.434179,
      NULL,
      117,
      5.663419,
      0.427164,
      NULL,
      NULL,
      102,
      93.053885,
      78,
      23.484328,
      ' 2-29-1977',
      12.744468,
      60.841046,
      23.272772,
      15.526360,
      115.607590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      8.521845,
      0.452896,
      5.379336,
      4.686432,
      8,
      ' 2-29-1989',
      0.310503,
      NULL,
      NULL,
      1,
      NULL,
      68,
      0.573391,
      3,
      50.716715,
      NULL,
      NULL,
      NULL,
      ' 8-10-1977',
      25,
      94.937607,
      64.397562,
      26.462385,
      44.608430,
      69.724593,
      NULL,
      46.058876,
      1,
      NULL,
      NULL,
      17,
      ' 1- 5-1990',
      4,
      9.475252,
      2,
      NULL,
      30,
      2,
      NULL,
      ' 0- 7-1989',
      17.814162,
      13.147081,
      ' 6-14-1993',
      0,
      8,
      25,
      26,
      NULL,
      12,
      1.621591,
      10,
      1,
      91,
      0,
      1.269669,
      4.737712,
      30.780102,
      0,
      0,
      1.814619,
      0.959687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99.624108,
      15.268029,
      ' 4-24-1987',
      NULL,
      NULL,
      NULL,
      39,
      ' 8-20-1979',
      30.991042,
      ' 0-21-1977',
      10,
      6.750490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      26.771760,
      ' 3- 6-1993',
      10,
      41.516588,
      11,
      ' 1-17-1982',
      NULL,
      13,
      ' 6- 5-1997',
      15,
      NULL,
      NULL,
      8,
      ' 5-12-2002',
      25,
      0,
      NULL,
      ' 3-19-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


