set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6316025';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3233',
      '00404132',
      '31330423',
      '12142010',
      '41420324',
      '13420032',
      '23200334',
      '01232320',
      NULL,
      '00333202',
      '33200023',
      '22411001',
      '02302141',
      '22202204',
      '20241440',
      '04144434',
      '43103332',
      '41240004',
      '21111210',
      '22223114',
      NULL,
      '01000114',
      '31400421',
      '10301111',
      '10201122',
      '44434413',
      '42104024',
      '11122044',
      '10011030',
      '13033032',
      '41412421',
      '13023412',
      '20221333',
      '02110244',
      '33020230',
      '13011423',
      '32222014',
      '13044103',
      '30400240',
      '42230343',
      '03104330',
      '32314203',
      '22001114',
      '43002332',
      '34320212',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '200223',
      3.368525,
      '10-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      13.607740,
      14.039688,
      3.670748,
      88,
      17,
      6,
      0,
      47.370977,
      5,
      26.512802,
      19.534290,
      NULL,
      2,
      10,
      0.594488,
      24,
      12.663723,
      43,
      3,
      78,
      3.106940,
      NULL,
      14,
      20,
      16.754549,
      NULL,
      64,
      64.186937,
      ' 7-25-1996',
      NULL,
      23,
      4.040961,
      18.004396,
      39,
      161.740776,
      ' 7-23-1984',
      NULL,
      10,
      NULL,
      2.765616,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793707,
      1.870029,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      99.664403,
      28.090344,
      26.051369,
      46.254934,
      70.931828,
      59,
      106.410345,
      47,
      59,
      3.640774,
      ' 0-18-1990',
      NULL,
      1,
      13,
      18.913800,
      94.181777,
      9.272042,
      NULL,
      ' 5- 0-1984',
      17,
      NULL,
      ' 2-17-1980',
      9,
      10.786627,
      2,
      14.203554,
      NULL,
      9.379571,
      NULL,
      8.406419,
      NULL,
      44,
      0.245949,
      4.166407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      6.146117,
      4.280365,
      '11- 2-1986',
      0,
      375,
      ' 6- 9-1997',
      NULL,
      NULL,
      NULL,
      50,
      ' 5-24-1975',
      21.790937,
      0.574782,
      71.660254,
      ' 1-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.935565,
      NULL,
      116,
      41,
      110,
      45,
      13,
      66,
      3.417738,
      NULL,
      0,
      0.842467,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389429,
      0,
      1.646227,
      1.682164,
      0.686059,
      NULL,
      48,
      26.167866,
      108,
      0.918610,
      106.385013,
      0.753897,
      NULL,
      1.973727,
      3,
      1.924020,
      0,
      43.212381,
      75.158146,
      109.599259,
      1.749337,
      47,
      6,
      1.218927,
      70.946169,
      3.826982,
      1.630029,
      1.500424,
      8,
      15.792531,
      0.398865,
      0,
      0,
      NULL,
      NULL,
      0.855540,
      NULL,
      11.667269,
      1.657526,
      15,
      23,
      113,
      13,
      108.189596,
      2.124801,
      NULL,
      7,
      12.678095,
      1,
      1,
      0,
      0.445658,
      109.235145,
      ' 7-21-1999',
      '11- 2-2003',
      ' 1-10-1990',
      ' 4- 0-1982',
      ' 5-16-1999',
      ' 1- 8-1995',
      ' 4- 6-1987',
      NULL);
commit;
end;
/


