set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9125440';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1123',
      '14304414',
      '11302411',
      '41323222',
      NULL,
      '10444413',
      NULL,
      '30420412',
      NULL,
      '43032240',
      '23420414',
      '23203221',
      '12141123',
      NULL,
      '21404031',
      '32433101',
      '40310121',
      '01211323',
      NULL,
      '30221021',
      '40012211',
      NULL,
      '21243041',
      '21122300',
      NULL,
      '20020120',
      '44340034',
      '02043444',
      '31130204',
      '11304403',
      '43044413',
      '01133402',
      NULL,
      '30001403',
      '03444422',
      '31020141',
      '40034132',
      '22031424',
      '10044033',
      '03242031',
      '40320131',
      '31144240',
      '40244131',
      '32034232',
      '03302302',
      '323',
      NULL,
      NULL,
      NULL,
      '1210024',
      NULL,
      0.615591,
      1,
      NULL,
      '023401',
      1.619285,
      ' 1- 5-2000',
      ' 4-12-1997',
      70.768055,
      NULL,
      13.021223,
      10.145388,
      12.782843,
      4.528950,
      89,
      NULL,
      5.492828,
      20,
      NULL,
      10,
      6,
      12,
      18.858206,
      0,
      27.465002,
      13.257948,
      82.946683,
      19.339543,
      43,
      NULL,
      7.188869,
      10,
      1,
      NULL,
      43.052978,
      NULL,
      119,
      NULL,
      102.088816,
      ' 6-12-1984',
      40.386530,
      18.457041,
      8.335687,
      7,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      1.752168,
      1,
      3.661921,
      1.813555,
      NULL,
      1.402320,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1.120352,
      0.830321,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      7,
      0.029276,
      4,
      6,
      NULL,
      ' 6-25-1979',
      0.448973,
      1,
      137,
      NULL,
      1,
      NULL,
      1,
      0.740178,
      NULL,
      1.249758,
      0,
      14.653684,
      '11-21-2002',
      56.892397,
      NULL,
      NULL,
      54.190134,
      NULL,
      73,
      NULL,
      64.429874,
      48.864087,
      82.725979,
      19,
      7,
      NULL,
      20,
      24.245926,
      6,
      13.184685,
      58,
      NULL,
      10,
      ' 2-28-1984',
      20.377252,
      27,
      ' 5-17-1980',
      NULL,
      12.588757,
      15.956287,
      NULL,
      17,
      0.938306,
      1,
      NULL,
      0.322973,
      76,
      2.258535,
      NULL,
      4.917198,
      15,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      16,
      ' 0-10-1974',
      13.091866,
      25.690280,
      ' 6-24-1998',
      45.845849,
      NULL,
      34,
      NULL,
      11.724642,
      15,
      ' 0-23-1995',
      11.052730,
      69,
      ' 7- 6-1980',
      NULL,
      NULL,
      NULL,
      1,
      0.426306,
      NULL,
      2,
      1,
      11.574638,
      ' 7-12-1983',
      11,
      NULL,
      17.705049,
      ' 2-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.375958);
commit;
end;
/


