set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9235218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3222',
      '44431324',
      '23104444',
      '03041011',
      NULL,
      '30343441',
      '21400332',
      '00332224',
      '32332444',
      '14120011',
      NULL,
      NULL,
      NULL,
      NULL,
      '42341340',
      NULL,
      '40443333',
      '11400330',
      '20230340',
      '02440114',
      '43410224',
      '42202120',
      NULL,
      '00332042',
      '34014342',
      '11032031',
      '31101401',
      '02443034',
      '01112032',
      '11034021',
      '31224144',
      '23424012',
      '04223430',
      '44004030',
      '11203030',
      '00222020',
      '34203103',
      '42134004',
      NULL,
      '43440320',
      '42224432',
      '32300444',
      '34340103',
      '30320412',
      '01301340',
      NULL,
      '04',
      NULL,
      NULL,
      '2402032',
      NULL,
      0.687007,
      NULL,
      NULL,
      '000311',
      4.977735,
      ' 2-25-2001',
      ' 9-10-1990',
      64,
      NULL,
      20.255349,
      6,
      19.144153,
      7.004465,
      36.244491,
      7.798065,
      8.388478,
      5.489375,
      22,
      14.811875,
      9,
      9.879243,
      10.093682,
      18.737614,
      33.244978,
      13,
      17,
      12.011547,
      42.272567,
      19.792464,
      NULL,
      NULL,
      1,
      31,
      113,
      41,
      224.407762,
      215.413701,
      NULL,
      NULL,
      7.586484,
      71,
      18.760132,
      31,
      48,
      NULL,
      ' 4- 1-1996',
      1,
      2,
      1,
      0.157217,
      0.311858,
      0.520941,
      1,
      0,
      0,
      0,
      0.204217,
      NULL,
      NULL,
      NULL,
      1.349719,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-26-1989',
      NULL,
      NULL,
      3,
      2,
      1,
      7,
      ' 8-18-1985',
      0,
      NULL,
      138.733804,
      1,
      0,
      40,
      0.525247,
      3.627191,
      83.086212,
      0,
      0,
      NULL,
      NULL,
      79,
      83,
      50.852624,
      21.648792,
      52.325495,
      79.154049,
      NULL,
      NULL,
      57.462776,
      57,
      NULL,
      72,
      ' 9-18-1980',
      0,
      16.967328,
      2,
      26,
      67,
      72,
      NULL,
      ' 0-24-2003',
      28,
      28.913527,
      ' 1-27-1979',
      12.664694,
      12,
      20,
      16,
      5,
      4,
      1,
      6,
      2.346397,
      33.275868,
      3.444179,
      6,
      15,
      8.887408,
      0.872677,
      NULL,
      NULL,
      3,
      ' 1- 2-2001',
      9.947707,
      NULL,
      5,
      ' 3-11-1976',
      16,
      0.844897,
      ' 8-14-1990',
      NULL,
      NULL,
      ' 0-25-1988',
      NULL,
      ' 0-28-1983',
      NULL,
      NULL,
      0,
      8,
      ' 9-25-1995',
      13,
      44.245908,
      '11-29-1984',
      NULL,
      NULL,
      ' 3-24-2002',
      2.548696,
      NULL,
      ' 5-21-1981',
      0,
      2,
      1,
      NULL,
      NULL,
      35.600272,
      5,
      ' 7-17-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.363974);
commit;
end;
/


