set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232933';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0010',
      NULL,
      NULL,
      '32443300',
      '11132010',
      '20230032',
      NULL,
      NULL,
      NULL,
      '10432104',
      '03442403',
      '13344211',
      '23244142',
      '11424202',
      '30434040',
      '41323310',
      '00243224',
      '21201442',
      '00210112',
      '22431002',
      '10322032',
      '02021402',
      '22203223',
      '24310403',
      NULL,
      '33334011',
      '42314300',
      '44133141',
      '13020412',
      '14032401',
      NULL,
      '34400304',
      NULL,
      '33023320',
      '43422213',
      '12431330',
      NULL,
      '20100331',
      '03213012',
      NULL,
      '14234132',
      '40103313',
      NULL,
      '00432430',
      NULL,
      NULL,
      '03',
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      '032323',
      5.248658,
      NULL,
      ' 3-21-2002',
      9,
      NULL,
      32.747087,
      5.725394,
      8.198324,
      18,
      30.127368,
      11.670190,
      17.648932,
      23,
      18,
      10.451336,
      NULL,
      6.651636,
      6,
      17.257739,
      15.146212,
      12.447719,
      8.256101,
      4,
      NULL,
      3.152254,
      NULL,
      3,
      3.856246,
      58,
      91,
      52.083467,
      NULL,
      NULL,
      161.600886,
      ' 2-24-1991',
      22.689296,
      10.782331,
      0.531036,
      NULL,
      NULL,
      61.260690,
      ' 6-25-1989',
      NULL,
      2,
      7.007872,
      8,
      3,
      6,
      0,
      69,
      1,
      0,
      NULL,
      0.025458,
      0.698546,
      5,
      NULL,
      0.692816,
      2.525018,
      2.316301,
      0,
      76.994764,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1998',
      NULL,
      67.323391,
      15,
      9.425139,
      NULL,
      0,
      '10- 3-1983',
      1,
      0.430023,
      113.933175,
      7,
      2,
      97.590024,
      0,
      0,
      62.336202,
      NULL,
      NULL,
      NULL,
      ' 9- 6-2001',
      89,
      33.971835,
      89,
      22.917298,
      41,
      33,
      46.550891,
      1.540918,
      NULL,
      NULL,
      70,
      62,
      ' 1-25-1982',
      10.433517,
      23,
      8,
      22.167968,
      58.424300,
      50,
      NULL,
      ' 9-20-1994',
      13,
      12,
      '10- 0-1987',
      1.436870,
      3,
      NULL,
      28,
      20.077112,
      0.838241,
      2.077340,
      0.530060,
      1.373550,
      132,
      NULL,
      0,
      12,
      7.904492,
      2,
      1.358963,
      4.484275,
      NULL,
      ' 1-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1993',
      NULL,
      NULL,
      NULL,
      29,
      ' 0-10-1982',
      2.506469,
      ' 3-11-2001',
      12,
      4,
      ' 2-20-1991',
      72.046803,
      NULL,
      ' 6- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      16,
      ' 6-25-1999',
      60,
      NULL,
      7,
      ' 0-16-1984',
      0.410410,
      228,
      NULL,
      12,
      4.704316,
      21,
      122.003577,
      ' 0-12-2002',
      5.488584,
      NULL,
      NULL,
      ' 9-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


