set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1302',
      NULL,
      '10142302',
      '41344324',
      '13201030',
      NULL,
      '14201423',
      '42044031',
      '44234331',
      '02113312',
      '01112321',
      '41213224',
      NULL,
      '14330004',
      '30421424',
      NULL,
      '41112024',
      NULL,
      '22003244',
      '20102111',
      '14022130',
      '13134201',
      '32300423',
      '22341430',
      '01024204',
      '41024033',
      '11344000',
      '41241204',
      '01323241',
      '42210123',
      NULL,
      '41423141',
      '32110012',
      '30003420',
      NULL,
      '41303412',
      '13014022',
      '24020203',
      '21230031',
      '00222334',
      NULL,
      '42100002',
      NULL,
      NULL,
      '04430244',
      NULL,
      NULL,
      NULL,
      NULL,
      '3334030',
      3.736453,
      1.493867,
      2,
      NULL,
      '022040',
      5.756409,
      ' 1-18-1974',
      ' 8-27-1987',
      NULL,
      NULL,
      45.000416,
      20.019099,
      27,
      18,
      NULL,
      18.260032,
      2,
      19.505227,
      15.551168,
      18.265096,
      13,
      25,
      27.144679,
      NULL,
      22,
      12,
      86,
      2,
      29.230796,
      12,
      75.772372,
      NULL,
      1,
      29.601696,
      74,
      NULL,
      NULL,
      102,
      160,
      ' 3-11-1996',
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      231,
      ' 8- 7-1976',
      0.498357,
      1,
      1.253690,
      0,
      1,
      1,
      3,
      1.143689,
      1,
      0,
      1.599340,
      0.203999,
      NULL,
      1,
      0,
      NULL,
      1.862604,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1995',
      106,
      14.314824,
      1,
      12,
      4,
      3.348505,
      ' 9- 2-1995',
      NULL,
      0,
      116,
      NULL,
      1.680518,
      77.901153,
      0,
      NULL,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      23.146696,
      81.738870,
      NULL,
      85,
      0,
      NULL,
      33,
      55.267870,
      13.019056,
      NULL,
      NULL,
      11,
      ' 4- 7-1980',
      8,
      19.077046,
      NULL,
      32,
      2.993466,
      NULL,
      7.126213,
      NULL,
      2,
      17,
      '10- 4-1986',
      2,
      6,
      NULL,
      15.233854,
      NULL,
      7,
      1,
      10,
      0.842338,
      72.857874,
      0.508959,
      NULL,
      11.392097,
      21.616870,
      1,
      0,
      2.085253,
      1,
      ' 7- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      174.923254,
      1.908352,
      NULL,
      NULL,
      NULL,
      NULL,
      37.480508,
      ' 4-14-1999',
      NULL,
      ' 6-10-2000',
      NULL,
      NULL,
      ' 8-18-1996',
      55.847261,
      21,
      NULL,
      3,
      2,
      ' 4-24-1995',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21,
      ' 8- 4-1985',
      46.662005,
      11,
      26,
      '10-22-1980',
      1.182261,
      31.244122,
      ' 8- 3-1985',
      11.853188,
      8,
      4.164130,
      4.484420,
      ' 6-22-1999',
      44.169014,
      0.645798,
      NULL,
      ' 0- 3-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


