set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4422',
      '34420030',
      NULL,
      NULL,
      '22244401',
      '21444413',
      '24444014',
      '40200113',
      '33144211',
      '44313312',
      NULL,
      NULL,
      '01244431',
      '41411023',
      '30140331',
      '43103144',
      '14342202',
      '03032433',
      NULL,
      '04311101',
      '11340004',
      '01120112',
      '04134004',
      '00324410',
      NULL,
      '01120333',
      '04022430',
      NULL,
      '42003103',
      NULL,
      '22002020',
      '10320420',
      '31101241',
      '30321440',
      '42124440',
      '30234314',
      '34342422',
      '03301313',
      NULL,
      '13321241',
      '42014422',
      '03241043',
      '02340012',
      NULL,
      NULL,
      '122',
      NULL,
      28.562473,
      NULL,
      '2441024',
      3,
      15,
      3,
      NULL,
      '004121',
      4.009603,
      ' 1- 6-1983',
      ' 3-13-1987',
      2.234999,
      36,
      19.895852,
      31,
      NULL,
      8.587193,
      NULL,
      2.072060,
      16,
      6,
      41.048999,
      6.010612,
      49.459799,
      15.938295,
      13,
      2,
      NULL,
      NULL,
      29,
      2.642088,
      8.802594,
      9.173281,
      81,
      3.919017,
      1.267728,
      52,
      210.279630,
      98,
      59,
      269.455222,
      211,
      ' 1- 1-2001',
      18,
      29.709086,
      13.328715,
      31,
      182.865816,
      64,
      '10-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      5.536614,
      NULL,
      3.218998,
      7.614510,
      '10- 6-2003',
      0.250844,
      1.483353,
      132.689953,
      0,
      1,
      111.306593,
      2.053481,
      1,
      35,
      NULL,
      NULL,
      NULL,
      ' 2-29-2000',
      NULL,
      NULL,
      71.066442,
      99.908678,
      85.016752,
      NULL,
      76,
      67,
      96.510557,
      23,
      35.697981,
      NULL,
      ' 3-22-1996',
      19.302568,
      15.864866,
      NULL,
      15,
      5.124198,
      18.716074,
      9,
      ' 5-29-1988',
      23,
      NULL,
      ' 2- 6-1991',
      0.746256,
      13,
      6,
      18,
      19,
      12,
      NULL,
      14.193646,
      1.932840,
      55.765809,
      NULL,
      0,
      3.028555,
      18.054189,
      2,
      1.907189,
      0,
      0.724337,
      ' 0- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.351863,
      ' 3-11-1978',
      NULL,
      NULL,
      NULL,
      41.393086,
      '10-10-1992',
      20.632380,
      NULL,
      NULL,
      9,
      ' 9-26-2003',
      NULL,
      23.103487,
      ' 4-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      9,
      ' 5-12-1993',
      62.001412,
      35,
      12,
      ' 4- 8-1988',
      0,
      13.616594,
      ' 4-14-1990',
      9.805477,
      NULL,
      7,
      23,
      ' 3- 5-1992',
      14,
      NULL,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


