set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      '3',
      '0',
      '0',
      '4',
      '0',
      '0',
      '3',
      '0',
      '1',
      '3',
      '3',
      '4',
      '1',
      '0',
      '0',
      '3',
      '4',
      '4',
      '3',
      '2',
      '2',
      '',
      '1',
      '',
      NULL,
      '4',
      '3',
      '3',
      '1',
      '',
      '',
      '3',
      '3',
      '4',
      '1',
      '1',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '1',
      '304',
      '24342221',
      30.703420,
      7.010011,
      NULL,
      NULL,
      51.138335,
      1,
      NULL,
      '232131',
      4,
      ' 8-24-1986',
      ' 1-18-1978',
      38.793669,
      225.426506,
      40.083777,
      4.819352,
      13,
      16.988563,
      22.263064,
      NULL,
      NULL,
      NULL,
      27,
      6,
      27,
      20,
      23.981762,
      19,
      25.351767,
      12,
      70,
      0,
      53,
      NULL,
      NULL,
      31.584428,
      0.248972,
      113,
      186.035171,
      24.698519,
      171.821759,
      93,
      66,
      ' 6- 7-2002',
      NULL,
      28,
      31,
      14.910209,
      144.821962,
      52.325515,
      ' 4-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.596181,
      NULL,
      8,
      NULL,
      7,
      5,
      '10-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      0.271924,
      125,
      0,
      0.981033,
      16.639453,
      NULL,
      NULL,
      NULL,
      ' 9-27-1981',
      NULL,
      43,
      50,
      70.815949,
      66,
      109.277739,
      105,
      26.035857,
      46,
      16,
      88,
      93,
      ' 7-20-2003',
      2.592009,
      NULL,
      3.063465,
      38,
      32.862942,
      10.816849,
      1.523512,
      ' 8-14-1994',
      13.968088,
      18,
      ' 8- 5-1994',
      NULL,
      5.964757,
      NULL,
      0.613805,
      12,
      6.810800,
      1,
      11,
      NULL,
      NULL,
      1,
      0,
      4,
      8,
      4.374349,
      2.237236,
      0,
      NULL,
      ' 1-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      249.175955,
      1,
      '11-11-1989',
      NULL,
      NULL,
      NULL,
      46.297688,
      ' 2-20-1982',
      33,
      ' 1-19-1977',
      2.963376,
      7,
      NULL,
      65.629765,
      94.651217,
      ' 4-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      8,
      ' 3- 6-1998',
      23.799714,
      6.953100,
      0.544026,
      '10-17-1987',
      1,
      79.221317,
      ' 3-18-1980',
      4.113207,
      11,
      21.360311,
      33,
      NULL,
      30.826315,
      0,
      15.983585,
      ' 9-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


