set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '1',
      NULL,
      '4',
      '2',
      '2',
      '0',
      '1',
      '3',
      '1',
      '3',
      '3',
      NULL,
      '0',
      '4',
      '2',
      NULL,
      '0',
      '1',
      '1',
      '0',
      NULL,
      NULL,
      '',
      '0',
      '',
      '0',
      '3',
      '3',
      '4',
      '0',
      '',
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '4',
      '2',
      '4',
      '0',
      '2',
      '0',
      NULL,
      '411',
      NULL,
      64.966557,
      68,
      '3002302',
      3.537853,
      127.898915,
      1,
      1,
      NULL,
      NULL,
      ' 1-10-1984',
      NULL,
      107.377269,
      72.709832,
      57,
      21,
      NULL,
      NULL,
      5.116884,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      21,
      14.342040,
      16.860631,
      2.105724,
      0,
      NULL,
      29,
      4,
      10.970558,
      1,
      110.258434,
      8.920125,
      0,
      41.507080,
      NULL,
      100,
      16,
      122.327844,
      63.862038,
      ' 8-23-1981',
      5.029071,
      8.622041,
      37.813449,
      13,
      NULL,
      197.020756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      5,
      3.310349,
      7.844798,
      2.802355,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.556689,
      0.735380,
      185.360776,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      87.319374,
      0.302778,
      NULL,
      59,
      12,
      54,
      NULL,
      59,
      ' 7- 0-1998',
      11.808128,
      NULL,
      0,
      22,
      12,
      7.616871,
      NULL,
      ' 5- 8-1981',
      7,
      16.907341,
      ' 0- 3-1974',
      3.613387,
      15,
      17,
      2,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      0.145835,
      1,
      NULL,
      NULL,
      1.842374,
      0,
      1,
      0.424209,
      ' 6-29-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      1,
      ' 6- 2-1977',
      NULL,
      NULL,
      NULL,
      51.745694,
      ' 5- 1-1987',
      NULL,
      ' 1- 8-1992',
      7.482262,
      NULL,
      ' 1- 7-1993',
      NULL,
      138.694086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 3-13-1984',
      63.561861,
      25,
      9.550726,
      NULL,
      0.168025,
      26,
      ' 8-10-2000',
      0,
      17.927589,
      18.548643,
      23.141511,
      NULL,
      11,
      NULL,
      18.298776,
      ' 6-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


