set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8520452';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3201',
      '33421322',
      NULL,
      '43422301',
      '21443230',
      '44403243',
      '14210341',
      '24423300',
      '04210434',
      '42044232',
      '14121140',
      '10023300',
      NULL,
      NULL,
      NULL,
      '40240342',
      '10343001',
      '44211041',
      '01144400',
      '14422423',
      '44133034',
      '01203022',
      '13313113',
      '00242440',
      '44041201',
      NULL,
      '24320103',
      '00130433',
      '23023431',
      '31210122',
      '21432214',
      '14034221',
      '32004202',
      '44243031',
      NULL,
      '32403133',
      '23404231',
      '33243223',
      '03211203',
      '21241434',
      '34414012',
      NULL,
      '41402042',
      '12104443',
      '10030313',
      '100',
      NULL,
      39.338429,
      NULL,
      '3241043',
      NULL,
      NULL,
      1,
      NULL,
      '002044',
      1.356948,
      ' 5- 3-2000',
      ' 5-23-1978',
      44.103673,
      94,
      NULL,
      10,
      27.677619,
      10.740327,
      22,
      29.772076,
      14,
      0.783081,
      52.320035,
      13.426318,
      34.712056,
      27.198659,
      NULL,
      6.149207,
      NULL,
      11.995625,
      71,
      5,
      30.443918,
      0.373169,
      NULL,
      16,
      1,
      NULL,
      4.679351,
      36.705763,
      NULL,
      143,
      163.021845,
      NULL,
      58.957472,
      64.127602,
      36,
      28,
      NULL,
      37.092660,
      ' 1-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0,
      NULL,
      NULL,
      5.134161,
      2,
      ' 7-22-1999',
      NULL,
      0.555117,
      14.236279,
      1.679960,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-2000',
      1.990457,
      42,
      52.503501,
      31,
      68.961525,
      48.358530,
      37,
      22.084493,
      23.137593,
      53.793038,
      86,
      72.268809,
      '11- 2-2002',
      8,
      7,
      15.337020,
      59.465413,
      3.726083,
      NULL,
      1,
      ' 3- 1-1980',
      NULL,
      43,
      ' 0-17-1994',
      3.944168,
      16,
      3,
      30.780731,
      NULL,
      4,
      1,
      18.178879,
      0.459678,
      145,
      1.552430,
      0.631694,
      10.802598,
      10,
      1.852380,
      0.510728,
      0.757191,
      1,
      ' 8- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.805648,
      ' 6-18-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 6-2003',
      NULL,
      ' 3-22-1975',
      13.209886,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      19,
      '11- 8-1996',
      41.993702,
      30,
      35,
      ' 9-15-1997',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


