set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '1',
      '3',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '0',
      '1',
      NULL,
      '2',
      '4',
      '1',
      '2',
      '4',
      '3',
      '4',
      '3',
      '2',
      '2',
      '3',
      NULL,
      '',
      '3',
      '',
      '2',
      '4',
      '0',
      '0',
      NULL,
      '',
      '',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4',
      '3',
      '0',
      '0',
      NULL,
      '4',
      NULL,
      '43433111',
      41,
      9.365451,
      '1011241',
      NULL,
      0,
      3,
      NULL,
      '104003',
      6,
      NULL,
      '10- 9-1979',
      34,
      4,
      37,
      NULL,
      12,
      NULL,
      94,
      2,
      17.948856,
      6,
      3,
      NULL,
      4,
      7,
      17.758977,
      14.410135,
      5,
      10,
      57,
      2.560009,
      NULL,
      13,
      36.966464,
      14,
      1,
      49.671612,
      94,
      63.518089,
      160,
      90.111540,
      7,
      ' 7-10-1982',
      0.767498,
      60,
      32.181602,
      21,
      119,
      117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      23,
      7,
      2,
      0,
      3.025227,
      ' 2-14-2000',
      0.256712,
      1.242245,
      172.009222,
      0.404621,
      0,
      100.450106,
      1.689857,
      0.833065,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-2002',
      16,
      99,
      56,
      29,
      85.232767,
      85.218121,
      81.014666,
      NULL,
      44.856014,
      34,
      23,
      18,
      '10- 0-1991',
      12,
      9,
      6,
      11.642226,
      36,
      NULL,
      9,
      ' 9- 8-1981',
      NULL,
      NULL,
      ' 4- 7-1998',
      3,
      11,
      11,
      4.757339,
      10,
      5.639596,
      1.920603,
      1.974010,
      1.940105,
      71,
      1,
      0.082490,
      NULL,
      24.833160,
      0.152024,
      2.374371,
      0,
      0,
      '11- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      ' 6-18-1996',
      NULL,
      NULL,
      NULL,
      13.870359,
      ' 3-25-1984',
      16.465518,
      '11- 0-1988',
      10.393107,
      14.706711,
      ' 5- 3-1978',
      105,
      13,
      ' 6-13-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      NULL,
      40.073919,
      NULL,
      14,
      ' 4- 7-2001',
      NULL,
      44,
      ' 3-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


