set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9864346';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      '4',
      '2',
      '2',
      '1',
      '3',
      '3',
      '2',
      '3',
      '3',
      '3',
      '4',
      '0',
      '4',
      '3',
      '4',
      '1',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '',
      '1',
      '',
      '2',
      '3',
      '2',
      '4',
      NULL,
      '',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '1',
      NULL,
      '4',
      '4',
      '1',
      '0',
      '2',
      '233',
      '04131000',
      34,
      46.603960,
      '3010400',
      0,
      NULL,
      NULL,
      NULL,
      '230444',
      3,
      ' 5-14-1993',
      '10-11-1987',
      23,
      152.374869,
      2,
      4,
      17,
      8,
      71.908389,
      NULL,
      10,
      5,
      8.580126,
      7,
      10,
      2.493245,
      23,
      1.351351,
      13,
      6.543354,
      6.227716,
      3.258639,
      48,
      3.164566,
      87,
      19,
      0,
      NULL,
      46.830571,
      3.264115,
      152,
      NULL,
      128,
      ' 5- 8-2001',
      NULL,
      NULL,
      NULL,
      19.005748,
      147,
      41,
      '11-12-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.776399,
      NULL,
      9,
      5,
      22,
      NULL,
      NULL,
      0,
      0.431709,
      89.638806,
      0.933580,
      2.936265,
      40,
      1,
      1,
      42.251755,
      NULL,
      NULL,
      NULL,
      ' 8-23-1992',
      52,
      NULL,
      64.455667,
      70.871830,
      5,
      99.486333,
      52,
      53,
      58.266359,
      57.697701,
      49,
      96,
      NULL,
      21,
      20.057590,
      NULL,
      16.482460,
      68.923271,
      93,
      7.679473,
      ' 0-26-1986',
      1.718746,
      3,
      NULL,
      1,
      11,
      12,
      NULL,
      NULL,
      5.249826,
      0,
      12,
      3.297044,
      6,
      0.062039,
      0.231898,
      11,
      18.923967,
      0.272466,
      1,
      NULL,
      1.634347,
      ' 6-13-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      10.511132,
      61,
      ' 6-17-2000',
      NULL,
      NULL,
      NULL,
      23.809991,
      ' 7-19-1983',
      NULL,
      NULL,
      12.410463,
      2.505038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.861763,
      NULL,
      64,
      0.395821,
      30,
      '10- 5-1979',
      0,
      82.775966,
      ' 8-13-1990',
      3,
      NULL,
      15,
      5.398034,
      '11-22-1986',
      29,
      1,
      114,
      ' 2- 0-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


