set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4231',
      '21324311',
      '24213204',
      NULL,
      '13314101',
      NULL,
      '43221321',
      NULL,
      '21443220',
      '10411221',
      '02302121',
      '20441203',
      '00112124',
      '33420332',
      '01312023',
      '14214413',
      '11304214',
      '01343113',
      '23021323',
      '22443212',
      '12223432',
      '22241242',
      '32424434',
      '40330003',
      '12241432',
      '21130013',
      NULL,
      '24041030',
      '00040404',
      '10004120',
      '13341324',
      '04400004',
      '00103442',
      '34304434',
      '10410314',
      NULL,
      '14401240',
      '20130221',
      '33133314',
      NULL,
      '13234212',
      '31120121',
      '32443214',
      '04214003',
      '32411231',
      '',
      '',
      NULL,
      NULL,
      '3420410',
      2.758882,
      NULL,
      NULL,
      NULL,
      '222034',
      NULL,
      '10- 3-1976',
      ' 1-22-1989',
      46,
      NULL,
      26.897980,
      6.224551,
      27.086582,
      16,
      7,
      5,
      8,
      NULL,
      1.281197,
      7.811227,
      0,
      NULL,
      22,
      17.374477,
      NULL,
      11.017872,
      43.981095,
      NULL,
      16,
      14,
      107.896733,
      11,
      NULL,
      27.268934,
      NULL,
      71,
      153,
      NULL,
      56,
      ' 0-21-1989',
      25,
      14.236558,
      7.762842,
      28.985602,
      171.581909,
      92,
      NULL,
      0,
      NULL,
      1.343426,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1987',
      64,
      107.950867,
      19.451410,
      NULL,
      59.436989,
      NULL,
      72.211587,
      77.798305,
      NULL,
      45,
      40,
      76.353508,
      ' 8-15-1981',
      0,
      NULL,
      NULL,
      13.592931,
      23,
      3.082716,
      5.176360,
      NULL,
      9,
      3,
      ' 0-14-1997',
      5,
      NULL,
      8.459371,
      7,
      3.671691,
      NULL,
      NULL,
      19.131706,
      NULL,
      NULL,
      5.936153,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.613055,
      22.622694,
      31.731948,
      ' 4-27-2002',
      3,
      143.343723,
      NULL,
      10.224554,
      13,
      7.342808,
      6,
      ' 3-17-1997',
      NULL,
      1,
      212.371594,
      ' 9-11-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      129,
      108,
      46.476597,
      NULL,
      NULL,
      32.973491,
      12.240087,
      131.342040,
      1.084984,
      28.417944,
      NULL,
      1.117807,
      125.414600,
      1.366343,
      0.711312,
      NULL,
      1.136390,
      NULL,
      9,
      0.655428,
      6,
      158.926444,
      19.650979,
      0.153633,
      NULL,
      1.792038,
      NULL,
      15.782660,
      1,
      NULL,
      3.870841,
      0.840841,
      0.414779,
      NULL,
      40.135076,
      90.144658,
      10,
      NULL,
      90,
      1.956880,
      2.768848,
      NULL,
      NULL,
      3,
      0.168045,
      NULL,
      0,
      43.843675,
      13.215571,
      1.828227,
      0,
      NULL,
      33,
      NULL,
      0.082724,
      12.465712,
      NULL,
      34.465927,
      5,
      3.694082,
      8.837875,
      5,
      1.676857,
      NULL,
      0.781516,
      NULL,
      0.312456,
      NULL,
      40.851399,
      ' 7-16-1975',
      NULL,
      ' 4-11-1976',
      '11- 6-1994',
      ' 9-16-1998',
      NULL,
      ' 7-22-1987',
      NULL);
commit;
end;
/


