set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0243',
      '34422334',
      '04112012',
      NULL,
      '34431411',
      '02034100',
      '12300114',
      '32404032',
      '34213212',
      '13414114',
      '13200320',
      '42112023',
      '14301041',
      '23304034',
      '43120243',
      '00211212',
      '42331203',
      NULL,
      '11023043',
      NULL,
      '32043301',
      NULL,
      '31441301',
      '23140422',
      NULL,
      NULL,
      '20403302',
      '14022242',
      '12033422',
      '23001132',
      '24040403',
      '12240432',
      NULL,
      '01242123',
      '14301403',
      '13142440',
      '23114234',
      '33032233',
      '00412414',
      '13413434',
      NULL,
      '03424024',
      '32330014',
      '32221324',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '3142433',
      3,
      13.194852,
      2,
      NULL,
      '202440',
      2,
      ' 4- 6-1986',
      ' 2- 7-2000',
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      53.771124,
      NULL,
      3.537583,
      1.914692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969584,
      1,
      2.453550,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-14-1974',
      109.643426,
      NULL,
      NULL,
      14,
      5,
      1.139661,
      47.663903,
      14.091905,
      40,
      NULL,
      21,
      74.723212,
      ' 0-11-1981',
      9.942508,
      19,
      NULL,
      11,
      47,
      8.845714,
      11.327083,
      ' 9-25-1980',
      4.867041,
      2,
      ' 1-29-1997',
      10,
      14,
      3,
      16,
      NULL,
      9.596501,
      NULL,
      23.525193,
      NULL,
      67.554649,
      0.256869,
      0,
      1.616821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      '10-19-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.294778,
      NULL,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      51.665109,
      1,
      0,
      26.291955,
      1,
      0.933559,
      47,
      0,
      4.617224,
      NULL,
      82,
      NULL,
      NULL,
      0.588054,
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92.117070,
      NULL,
      NULL,
      NULL,
      50.829245,
      0.139721,
      0,
      24,
      0,
      5,
      1.685819,
      5,
      0,
      17,
      4.124613,
      18,
      1.328286,
      0,
      44.331364,
      13,
      20,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.580470,
      1.561002,
      1.426150,
      3.877206,
      9.596429,
      NULL,
      NULL,
      NULL,
      '10-21-1979',
      ' 3- 2-1995',
      NULL,
      ' 9-25-2003',
      NULL);
commit;
end;
/


