set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1221',
      '30320103',
      '04221142',
      '03101144',
      '23412143',
      '04130332',
      '03320232',
      '03422324',
      NULL,
      NULL,
      '12132312',
      '23411033',
      NULL,
      '40202424',
      '04324134',
      '30434244',
      NULL,
      '24331243',
      '11021421',
      '33231331',
      '44004024',
      '34120342',
      '33413131',
      '34433032',
      '00113122',
      '23344111',
      '12132002',
      '13221411',
      '14222122',
      '00123243',
      '32301441',
      '04440334',
      '33204031',
      '21044440',
      '01311142',
      '42102430',
      '30232233',
      '11021011',
      NULL,
      '00304003',
      '11433400',
      '41211032',
      '02411103',
      '12120400',
      '23023121',
      '',
      '',
      NULL,
      NULL,
      '3324230',
      NULL,
      10,
      1,
      NULL,
      '424144',
      1,
      ' 4- 8-1974',
      ' 1- 3-1984',
      18,
      NULL,
      39.734911,
      20,
      6.262618,
      NULL,
      NULL,
      6,
      NULL,
      18,
      20,
      NULL,
      NULL,
      4.809585,
      19.719360,
      NULL,
      23.078500,
      18.353932,
      26,
      19.465816,
      4.181539,
      2.902465,
      51.148333,
      14,
      NULL,
      NULL,
      NULL,
      102.569557,
      60.322356,
      118.138128,
      191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.931892,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.765177,
      1.125474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1977',
      75.802006,
      51,
      56,
      97,
      44.517280,
      104.609291,
      NULL,
      38.517474,
      34,
      37.495702,
      26,
      13,
      NULL,
      22.215960,
      NULL,
      15,
      15.033490,
      61.013205,
      58,
      2,
      ' 6-22-1992',
      0,
      12,
      ' 6-24-1982',
      NULL,
      NULL,
      16.274779,
      8.684000,
      NULL,
      5.069159,
      NULL,
      3,
      NULL,
      28.592647,
      3.325946,
      5.570102,
      3.524192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      17,
      65.084619,
      NULL,
      0.109013,
      107.873372,
      ' 7-13-1982',
      9,
      79,
      8,
      NULL,
      ' 7- 5-1991',
      55.956384,
      0,
      141,
      ' 3-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      85,
      27,
      7,
      NULL,
      NULL,
      1,
      25,
      0.738734,
      8,
      1.099218,
      1.693382,
      72,
      1.217001,
      0,
      NULL,
      1,
      2.846471,
      NULL,
      2,
      NULL,
      299.894203,
      38,
      1.684388,
      21.811462,
      0,
      NULL,
      NULL,
      0.530540,
      1,
      0,
      0.529071,
      NULL,
      NULL,
      68,
      95,
      NULL,
      NULL,
      85.317778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      24.324234,
      NULL,
      6,
      25.303093,
      26,
      3,
      3,
      NULL,
      82,
      NULL,
      NULL,
      8.120445,
      8,
      NULL,
      5.114755,
      0.060129,
      NULL,
      NULL,
      NULL,
      99,
      '10- 3-2001',
      ' 1-14-1982',
      NULL,
      NULL,
      ' 0- 8-1992',
      NULL,
      NULL,
      NULL);
commit;
end;
/


