set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3103',
      '24410434',
      '40024031',
      NULL,
      NULL,
      '31110042',
      '12244031',
      '40102332',
      '44244440',
      '44014230',
      '01031323',
      '12202104',
      '41232311',
      '23300132',
      '41331323',
      '44230114',
      '00022110',
      '13040222',
      '01424143',
      '33241323',
      '03113434',
      '02033010',
      '04142234',
      '23402132',
      '40443013',
      '30304131',
      '14330124',
      NULL,
      '22114430',
      '34222000',
      '30442242',
      '20141310',
      NULL,
      '12231101',
      '14414412',
      '33134413',
      NULL,
      '21233302',
      '31303230',
      '43032434',
      '23330312',
      '23343332',
      '22201020',
      '24234231',
      NULL,
      '201',
      '01',
      NULL,
      NULL,
      '1311341',
      0.668393,
      118.916520,
      NULL,
      NULL,
      '330111',
      5,
      ' 2-25-1974',
      NULL,
      NULL,
      NULL,
      6.119920,
      NULL,
      NULL,
      21.169761,
      28,
      8,
      25.212669,
      5,
      14.436304,
      NULL,
      28.731485,
      15,
      15.838781,
      13.829255,
      4.323680,
      4.034559,
      NULL,
      0,
      18,
      13.695015,
      62,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      197.978747,
      31.876149,
      42.454534,
      ' 4- 6-1999',
      13.480572,
      34,
      3.666685,
      20,
      17,
      86.776796,
      NULL,
      0.065817,
      0.507048,
      0,
      0,
      1.288841,
      0.522488,
      0,
      1.413577,
      1.649634,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.553544,
      1,
      1.001880,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-20-1998',
      37.334448,
      8.716094,
      9.650075,
      9,
      0,
      NULL,
      ' 3-29-1988',
      1.990834,
      0,
      NULL,
      0.388205,
      3,
      50,
      1.946788,
      0,
      43,
      NULL,
      NULL,
      NULL,
      ' 6-26-1981',
      76,
      72,
      30,
      NULL,
      61.755454,
      18.294654,
      89.829016,
      80.123351,
      77,
      52.841151,
      0,
      68.967193,
      '11-29-2003',
      6.670544,
      0.347321,
      25.952914,
      31,
      NULL,
      142.058812,
      10.725287,
      ' 4-19-1998',
      NULL,
      26,
      ' 6-29-2003',
      3,
      21.688225,
      22.893502,
      22,
      29,
      10.722631,
      1,
      11,
      1.628906,
      7.340490,
      NULL,
      NULL,
      4.837751,
      7.989849,
      1.216660,
      1.746814,
      3.599309,
      NULL,
      ' 5-19-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      131,
      5.071711,
      ' 8-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1974',
      20.299521,
      ' 9-13-1991',
      4,
      7,
      NULL,
      68,
      81,
      ' 3- 0-1999',
      NULL,
      11,
      ' 8- 6-2002',
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 7-27-1991',
      63,
      11,
      41.788256,
      ' 7-26-2000',
      0.166608,
      NULL,
      '11- 7-1998',
      6.299365,
      NULL,
      6,
      112.767741,
      '11-11-1993',
      NULL,
      1,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


